#import "UIView+AAILD.h"

@implementation UIView (AAILD)

- (UIView *)aaild_safeMarginToView:(UIView *)toView
                            t:(NSNumber * _Nullable)top
                            l:(NSNumber * _Nullable)left
                            b:(NSNumber * _Nullable)bottom
                            r:(NSNumber * _Nullable)right
{
    
    NSMutableArray<NSLayoutConstraint *> * arr = [[NSMutableArray alloc] initWithCapacity:4];
    
    if (@available(iOS 11.0, *)) {
        if (top != nil) {
            NSLayoutConstraint *topCons = [self.topAnchor constraintEqualToAnchor:toView.safeAreaLayoutGuide.topAnchor constant:[top doubleValue]];
            [arr addObject: topCons];
        }
        
        if (left != nil) {
            NSLayoutConstraint *leftCons = [self.leftAnchor constraintEqualToAnchor:toView.safeAreaLayoutGuide.leftAnchor constant:[left doubleValue]];
            [arr addObject: leftCons];
        }
        
        if (bottom != nil) {
            NSLayoutConstraint *bottomCons = [self.bottomAnchor constraintEqualToAnchor:toView.safeAreaLayoutGuide.bottomAnchor constant:[bottom doubleValue]];
            [arr addObject: bottomCons];
        }
        
        if (right != nil) {
            NSLayoutConstraint *rightCons = [self.rightAnchor constraintEqualToAnchor:toView.safeAreaLayoutGuide.rightAnchor constant:[right doubleValue]];
            [arr addObject: rightCons];
        }
        
        [NSLayoutConstraint activateConstraints:arr];
    } else {
        [self aaild_marginToView:toView t:top l:left b:bottom r:right];
    }
    
    return self;
}

- (UIView *)aaild_marginToView:(UIView *)toView
                            t:(NSNumber * _Nullable)top
                            l:(NSNumber * _Nullable)left
                            b:(NSNumber * _Nullable)bottom
                            r:(NSNumber * _Nullable)right
{
    self.translatesAutoresizingMaskIntoConstraints = NO;
    
    NSMutableArray<NSLayoutConstraint *> * arr = [[NSMutableArray alloc] initWithCapacity:4];
    
    if (top != nil) {
        NSLayoutConstraint *topCons = [self.topAnchor constraintEqualToAnchor:toView.topAnchor constant:[top doubleValue]];
        [arr addObject: topCons];
    }
    
    if (left != nil) {
        NSLayoutConstraint *leftCons = [self.leftAnchor constraintEqualToAnchor:toView.leftAnchor constant:[left doubleValue]];
        [arr addObject: leftCons];
    }
    
    if (bottom != nil) {
        NSLayoutConstraint *bottomCons = [self.bottomAnchor constraintEqualToAnchor:toView.bottomAnchor constant:[bottom doubleValue]];
        [arr addObject: bottomCons];
    }
    
    if (right != nil) {
        NSLayoutConstraint *rightCons = [self.rightAnchor constraintEqualToAnchor:toView.rightAnchor constant:[right doubleValue]];
        [arr addObject: rightCons];
    }
    
    [NSLayoutConstraint activateConstraints:arr];
    
    return self;
}

- (UIView *)aaild_width:(NSNumber * _Nullable)width height:(NSNumber * _Nullable)height
{
    self.translatesAutoresizingMaskIntoConstraints = NO;
    
    NSMutableArray<NSLayoutConstraint *> * arr = [[NSMutableArray alloc] initWithCapacity:2];
    
    if (width != nil) {
        NSLayoutConstraint *widthCons = [self.widthAnchor constraintEqualToConstant:[width doubleValue]];
        [arr addObject: widthCons];
    }
    
    if (height != nil) {
        NSLayoutConstraint *heightCons = [self.heightAnchor constraintEqualToConstant:[height doubleValue]];
        [arr addObject: heightCons];
    }
    
    [NSLayoutConstraint activateConstraints:arr];
    
    return self;
}

@end
