//
//  AAILDOnPremiseModeConfig.h
//  AAILivenessSDK
//
//  Created by advance on 2025/8/13.
//

#import <Foundation/Foundation.h>
#import <AAILivenessSDK/AAILDInitConfig.h>
    
NS_ASSUME_NONNULL_BEGIN

__attribute__((visibility("default")))
@interface AAILDOnPremiseModeConfig : NSObject <AAILDInitConfig>

/// The domain of the on-premise mode.
/// @since 4.1.0
@property (nonatomic, readonly) NSString *domain;

/// The access key of the on-premise mode.
/// @since 4.1.0
@property (nonatomic, readonly, nullable) NSString *accessKey;

/// The secret key of the on-premise mode.
/// @since 4.1.0
@property (nonatomic, readonly, nullable) NSString *secretKey;

/// Initialize the on-premise mode config.
/// @since 4.1.0
+ (instancetype)initWithDomain:(NSString *)domain
                     accessKey:(NSString *)accessKey
                     secretKey:(NSString *)secretKey;

@end

NS_ASSUME_NONNULL_END
