//
//  AAILivenessVideoConfig.h
//  AAILivenessSDK
//
//  Created by advance on 2022/10/9.
//  Copyright © 2022 Advance.ai. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AAILivenessSDK/AAIVideoRecordResult.h>
#import <AAILivenessSDK/AAIVideoRecordDelegate.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, AAIVideoRecordStage) {
    /// Don't record video.
    AAIVideoRecordStageUnspecified = 0,
    
    /// Record videos of the preparation stage and the motion stage.
    /// @warning This option is deprecated and is no longer supported since v4.0.0
    AAIVideoRecordStagePrepareAndMotion = 1,
    
    /// Only record the video of the preparation stage.
    /// @warning This option is deprecated and is no longer supported since v4.0.0
    AAIVideoRecordStagePrepare = 2,
    
    /// Only record the video of the motion stage.
    /// @warning This option is deprecated and is no longer supported since v4.0.0
    AAIVideoRecordStageMotion = 3,
    
    /// Record all stages until the maximum duration is reached or the detection flow is completed
    /// @since 4.0.0
    AAIVideoRecordStageAll = 4
};

__attribute__((visibility("default")))
@interface AAIVideoConfig : NSObject

/// An object conforming to the AAIVideoRecordDelegate protocol that will receive video result when the recording is done.
///
/// @warning Normally you should call `[AAILivenessSuccessResult syncGetVideoRecordResult]` or `[AAILivenessFailureResult syncGetVideoRecordResult]` to get the video result.
@property(nonatomic, weak, nullable) id<AAIVideoRecordDelegate> delegate;

/// The stage of the video to be recorded. Default is "AAIVideoRecordStageAll".
@property(nonatomic) AAIVideoRecordStage recordStage;

/// Maximum duration of video recording in seconds. Default is 0s, which means no limit.
/// @warning Since 4.1.2, the default value changed to 0s.
/// For older SDK versions, the default value is 60s, and available values are in the range [2, 60].
@property(nonatomic) NSInteger maxRecordDuration;

/// Generate a default AAIVideoConfig instance. Not that you should always call this method to generate a AAIVideoConfig instance.
+ (AAIVideoConfig *)defaultConfig;

@end

NS_ASSUME_NONNULL_END
