// swift-tools-version: 5.6
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

// If you want to minimize the size of the package, you can exclude optional dependencies according to your needs.
// Set the flags to false to exclude optional dependencies
let includeAAILivenessModel = true  // Set to false to exclude
let includeAAIDataVisor = true  // Set to false to exclude

var deps: [PackageDescription.Target.Dependency] = ["AAILivenessSDK", "AAINetwork", "AAICore"]

if includeAAILivenessModel {
  deps.append("AAILivenessModel")
}
if includeAAIDataVisor {
  deps.append("AAIDataVisor")
}

var mainTargetDeps: [PackageDescription.Target] = [
  .binaryTarget(
    name: "AAILivenessSDK",
    path: "Frameworks/AAILivenessSDK.xcframework"),

  .binaryTarget(
    name: "AAINetwork",
    url: "https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-libraries/AAINetwork/AAINetwork-V1.0.4.xcframework.zip",
    checksum: "676c14e1e823ca30a5c7ac6f0cc46c2495ae642a5e7bee5fc39f2e6b5d1c8d31"),

  .binaryTarget(
    name: "AAICore",
    url: "https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-libraries/AAICore/1.0.2/AAICore-V1.0.2.xcframework.zip",
    checksum: "3e6a97cfe7c93abc1f1e3ab97c4922d4b52f8cdcd53721ab306da3a0527af44b"),

  .target(
    name: "AAILivenessUI",
    dependencies: deps,
    path: "Sources",
    resources: [
      .copy("Resource/AAIAudio.bundle"),
      .copy("Resource/AAIImgs.xcassets"),
      .copy("Resource/AAILanguageString.bundle"),
      .process("Resource/PrivacyInfo.xcprivacy"),
    ],

    publicHeadersPath: "Classes/include",
    cxxSettings: [
      .headerSearchPath("Classes/AAILiveness"),
      .headerSearchPath("Classes/Private"),
    ]),
]

if includeAAILivenessModel {
  mainTargetDeps.append(
    .binaryTarget(
      name: "AAILivenessModel",
      url: "https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-libraries/AAILivenessModel/4.0.0/AAILivenessModel-V4.0.0.xcframework.zip",
      checksum: "52fcce225a31d943838987d3ebeb8fe0602373de64c30fa4db1afa0a3758601b"))
}

if includeAAIDataVisor {
  mainTargetDeps.append(
    .binaryTarget(
      name: "AAIDataVisor",
      url:  "https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-AAIDataVisor-SDK/0.1.7/c4d14eafeb10c2bc0e0d0d0ab7b44bd4ca9e90161918ee6cfd1eb8cd56c57738/AAIDataVisor.zip",
      checksum: "c4d14eafeb10c2bc0e0d0d0ab7b44bd4ca9e90161918ee6cfd1eb8cd56c57738"))
}

let package = Package(
  name: "AAILivenessUI",
  defaultLocalization: "en",
  products: [
    // Products define the executables and libraries a package produces, making them visible to other packages.
    .library(
      name: "AAILivenessUI",
      type: nil,
      targets: ["AAILivenessUI"])
  ],
  targets: mainTargetDeps
)
