//
//  AAICustomLD03Controller.swift
//  LivenessSDKSwiftDemo
//
//  Created by advance on 2022/12/7.
//

import Foundation
import AAILivenessUI
import UIKit

class AAICustomLD03Controller: AAILivenessViewController {
    private var _myViewfinder: CAShapeLayer?
    private var _myTitleLabel: UILabel?
    private var _myImgBorderView: UIImageView?
    private var _myLogoImgView: UIImageView?
    
    override func livenessWrapViewDidLoad(_ wrapView: AAILivenessWrapView) {
        super.livenessWrapViewDidLoad(wrapView)
        
        /*
        // Subclass can override this method to customize the UI
        wrapView.backgroundColor = .gray
        */
        
        /*
        //Custom preview area margin top
        wrapView.configAvatarPreviewMarginTop = {(wrapViewFrame) in
            return 64
        }
        */
        
        /*
        //Custom preview area width
        wrapView.configAvatarPreviewWidth = {(wrapViewFrame) in
            return 300
        }
        */
    }
    
    override func loadAdditionalUI() {
        super.loadAdditionalUI()
        
        // Configure your own UI
        // e.g. Remove UI controls that are not important to you.
        if let stateImgView = self.value(forKey: "_stateImgView") as? UIImageView {
            stateImgView.isHidden = true
        }
        
        if let timeLabel = self.value(forKey: "_timeLabel") as? UILabel {
            timeLabel.textColor = .blue
            timeLabel.layer.borderColor = UIColor.black.cgColor
        }
        
        if let stateLabel = self.value(forKey: "_stateLabel") as? UILabel {
            stateLabel.textColor = .black
        }
        
        if let voiceBtn = self.value(forKey: "_voiceBtn") as? UIButton {
            voiceBtn.removeFromSuperview()
        }
        
        if let backBtn = self.value(forKey: "_backBtn") as? UIButton {
            if let backBtnImg = backBtn.image(for: .normal) {
                let newBackBtnImg = backBtnImg.withRenderingMode(.alwaysTemplate)
                backBtn.setImage(newBackBtnImg, for: .normal)
                backBtn.tintColor = .red
            }
        }
        
        let myTitleLabel = UILabel()
        myTitleLabel.textColor = .green
        myTitleLabel.textAlignment = .center
        myTitleLabel.text = self.title
        self.view.addSubview(myTitleLabel)
        _myTitleLabel = myTitleLabel
        
        let imgBorderView = UIImageView()
        imgBorderView.layer.borderColor = UIColor.blue.cgColor
        imgBorderView.layer.borderWidth = 2
        self.view.addSubview(imgBorderView)
        _myImgBorderView = imgBorderView
        
        // Add logo view
        let logoImgView = UIImageView()
        logoImgView.layer.borderColor = UIColor.blue.cgColor
        logoImgView.layer.borderWidth = 2
        logoImgView.image = UIImage(named: "myLogo")
        self.view.addSubview(logoImgView)
        _myLogoImgView = logoImgView
        _myLogoImgView?.isHidden = true
        if let myLogo = _myLogoImgView?.image {
            let imgSize = myLogo.size
            _myLogoImgView?.image = myLogo
            _myLogoImgView?.bounds = CGRect(x: 0, y: 0, width: imgSize.width, height: imgSize.height)
        }
    }
    
    override func layoutAdditionalUI() {
        super.layoutAdditionalUI()
        
        guard let backBtn = self.value(forKey: "_backBtn") as? UIButton else {
            return
        }
        
        // Ajust UI
        let sw = self.view.frame.size.width
        
        let titleLabelBound = CGRect(x: 0, y: 0, width: (sw - backBtn.frame.maxX * 2), height: backBtn.frame.size.height)
        _myTitleLabel?.bounds = titleLabelBound
        _myTitleLabel?.center = CGPoint(x: sw/2, y: backBtn.center.y)
        
        guard let roundViewFrame = self.value(forKey: "_roundViewFrame") as? CGRect else {
            return
        }
        _myImgBorderView?.frame = roundViewFrame
    }
    
    override func ellipseWillTransition(_ context: AAIEllipseTrasitionContext) {
        super.ellipseWillTransition(context)
        
        // Update myLogoView position
        if (!CGRectIsEmpty(context.toFrame)) {
            let toFrame = context.toFrame;
            
            let updateLogoPosition: () -> Void = {
                // e.g. Place the logo at the bottom center of the avatar area
                if let myLogo = self._myLogoImgView?.image {
                    self._myLogoImgView?.center = CGPoint(x: CGRectGetMidX(toFrame), y: CGRectGetMaxY(toFrame) - myLogo.size.height)
                }
            }
            
            if (!CGRectIsEmpty(context.fromFrame)) {
                UIView.animate(withDuration: context.animationDuration, delay: 0, options: context.animationOptions, animations: {
                    updateLogoPosition()
                }, completion: nil)
            } else {
                updateLogoPosition()
                _myLogoImgView?.isHidden = false
            }
            
        }
    }
    
    override func tapBackBtnAction() {
        // Customize the back button logic
        self.presentingViewController?.dismiss(animated: true, completion: nil)
    }
    
    override var preferredStatusBarStyle: UIStatusBarStyle {
        return .default
    }
}
