//
//  AAIAdditionalConfig.h
//  AAILivenessSDK
//
//  Created by advance on 2022/11/17.
//  Copyright © 2022 Advance.ai. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AAILivenessSDK/AAIDetectionConstant.h>

typedef NS_ENUM(NSInteger, AAILDPluginType) {
    AAILDPluginTypeOther = -1,
    AAILDPluginTypeStandard = 0,
    AAILDPluginTypeReactNative = 1,
    AAILDPluginTypeFlutter = 2,
    AAILDPluginTypeCordova = 3,
    AAILDPluginTypeXamarin = 4,
    AAILDPluginTypeKMM = 5,
} AAI_LD_UNAVAILABLE_FROM(4.0.0);

NS_ASSUME_NONNULL_BEGIN

__attribute__((visibility("default")))
AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using class `AAILivenessConfig` instead")
@interface AAIAdditionalConfig : NSObject

/// The color of the round border in the avatar preview area. Default is clear color.
/// @warning This property only works on version 2.x.x
///
/// @since 2.0.0
@property(nonatomic) UIColor *roundBorderColor AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `normalAvatarBorderColor` of `AAILivenessConfig` instead");

/// The color of the ellipse dashed line that appears during the liveness detection. Default is white color.
/// @warning This property only works on version 2.x.x
///
/// @since 2.0.0
@property(nonatomic) UIColor *ellipseLineColor AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `innerEllipseDashedLineColor` of `AAILivenessConfig` instead");

/// The highlight color of the ellipse border in 3D mode(near/distant mode). Default is 0x5BC413.
///
/// @since 3.0.0
@property(nonatomic, nullable) UIColor *ellipseBorderCol3D AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `highlightAvatarBorderColor` of `AAILivenessConfig` instead");

/// The normal color of the ellipse border in 3D mode(near/distant mode). Default is 0xF5F5F5.
///
/// @since 3.3.0
@property(nonatomic, nullable) UIColor *normalEllipseBorderCol3D AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `normalAvatarBorderColor` of `AAILivenessConfig` instead");

/// The hightlight color of the inner ellipse animation line of the 3D mode(near/distant mode). Default is 0x5BC413.
///
/// @since 3.0.0
@property(nonatomic, nullable) UIColor *innerEllipseLineCol3D AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `innerAnimatedEllipseLineColor` of `AAILivenessConfig` instead");

/// The difficulty of liveness detection. Default is AAIDetectionLevelNormal.
///
/// @since 2.0.1
@property(nonatomic) AAIDetectionLevel detectionLevel AAI_LD_UNAVAILABLE_FROM(4.0.0);

/// In versions prior to SDK v3.0.0, this value only represents the timeout duration during the preparation stage.
///
/// From SDK v3.0.0 and later, this value actually represents the timeout duration in 3D mode(near/distant mode).
/// This time duration does not include network request duration.
///
/// @warning The range of values should be [10s, 60s], default is 50s.
///
/// @since 2.0.4
@property(nonatomic) NSInteger prepareTimeoutInterval AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `silentTimeout` of `AAILivenessConfig` instead");

/// The SDK can have different operating modes, such as silent detection mode, default mode(action mode). Default is 'AAILDOperatingModeSilent'.
/// @since 3.0.0
@property(nonatomic, readonly) AAILDOperatingMode operatingMode AAI_LD_UNAVAILABLE_FROM(4.0.0);


/// Wheather to collect audit images. Default is NO.
///
/// @since 3.1.0
@property(nonatomic) BOOL enableCollectAuditImages AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `enableCollect` of `AAILivenessConfig.auditImageConfig` instead");

/// The capture interval for audit images. Default is 400(ms).
///
/// @since 3.1.0
@property(nonatomic) NSInteger auditImageCaptureInterval AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `imageCaptureInterval` of `AAILivenessConfig.auditImageConfig` instead");

/// The maximum number of captures. Default is 20.
///
/// @since 3.1.0
@property(nonatomic) NSInteger auditImageMaxNumber AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `imageMaxNumber` of `AAILivenessConfig.auditImageConfig` instead");

/// The width of audit image. Default is 300.
///
/// @since 3.1.0
@property(nonatomic) NSInteger auditImageWidth AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `imageWidth` of `AAILivenessConfig.auditImageConfig` instead");

/// The quality of audit image. Default is 30. Available values in range [30, 100].
///
/// @since 3.1.2
@property(nonatomic) NSInteger auditImageQuality AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `imageQuality` of `AAILivenessConfig.auditImageConfig` instead");

/// Try capture a audit image at specific time (the relative time after the camera is launched). Default is 0(second), means no capture.
///
/// @since 3.3.0
@property(nonatomic) CGFloat relativeSecondsCaptureAfterCameraLaunched AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `relativeSecondsCaptureAfterCameraLaunched` of `AAILivenessConfig.auditImageConfig` instead");

/// Used to mark the plugin type. Default is nil. This value is used for distinguishing different plugins.
/// 
/// @since 3.4.0
@property(nonatomic) AAILDPluginType pluginType AAI_LD_UNAVAILABLE_FROM(4.0.0);

/// An optional string value used to conveniently query liveness detection results.
/// Call the `/liveness/generate-signature-id` API to generate this value, then assign it to
/// this field before starting a new liveness flow.
///
/// @warning The value must be unique per liveness flow. Passing a previously used value will result in a parameter error in SDK.
///  The SDK will automatically reset this field to nil after it is used.
///
/// @since 3.6.0
@property(nonatomic, nullable, copy) NSString *signatureId AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `signatureId` of `AAILivenessConfig` instead");

@end

NS_ASSUME_NONNULL_END
