Pod::Spec.new do |s|
  s.name             = 'AAILivenessUI'
  s.version          = '4.1.1'
  s.summary          = 'LivenessSDK UI module.'
  s.description      = <<-DESC
  This is a UI module, SDK UI is implemented in this module and it's open source.
                       DESC
  s.homepage     = 'https://www.advance.ai'
  s.license      = { :type => 'example', :text => <<-LICENSE
                      
                    LICENSE
                    }
  s.authors      = "advance.ai"
  s.ios.deployment_target = '10.0'

  s.source = { :http => 'https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/4.1.1/iOS-Liveness-SDK-V4.1.1.tar.bz2', type: :tbz }
  s.vendored_frameworks = 'AAILivenessSDK/AAILivenessSDK.xcframework'
  s.resource_bundles = {
    'AAILivenessResources' => [
      'AAILivenessSDK/AAILivenessUI/Resource/AAIAudio.bundle', 
      'AAILivenessSDK/AAILivenessUI/Resource/AAIImgs.xcassets', 
      'AAILivenessSDK/AAILivenessUI/Resource/AAILanguageString.bundle', 
      'AAILivenessSDK/AAILivenessUI/Resource/PrivacyInfo.xcprivacy']
  }
  s.public_header_files = 'AAILivenessSDK/AAILivenessUI/Classes/*.h'

  s.subspec 'Aoen' do |ss|
    ss.source_files = 'AAILivenessSDK/AAILivenessUI/Classes/Aoen/*'
  end

  s.subspec 'Private' do |ss|
    ss.source_files = 'AAILivenessSDK/AAILivenessUI/Classes/Private/*'
    
    ss.dependency 'AAILivenessUI/Aoen'
  end

  s.subspec 'AAILiveness' do |ss|
    ss.source_files = 'AAILivenessSDK/AAILivenessUI/Classes/AAILiveness/*'

    ss.dependency 'AAILivenessUI/Aoen'
    ss.dependency 'AAILivenessUI/Private'
  end

  s.frameworks = 'AVFoundation', 'CoreMotion', 'CoreGraphics', 'CoreTelephony', 'SystemConfiguration', 'Accelerate', 'Metal', 'MetalKit'
  s.ios.library = 'c++', 'z', 'resolv.9'
  
  s.dependency 'AAINetwork'
  s.dependency 'AAICore'
end
