//
//  AAILoadingHud.m
//  AAILivenessUI
//
//  Created by loong on 2024/7/10.
//

#import "AAILoadingHud.h"
#import "AAILoadView.h"
#import "View+ex.h"
#import "UIStackView+add.h"

@interface AAILoadingHud ()

@end

@implementation AAILoadingHud

- (instancetype)initWithText:(NSString *)text brandColor:(UIColor *)brandColor {
    self = [super initWithFrame:CGRectZero];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];

        UIStackView *colum = [[UIStackView alloc] init];
        colum.axis = UILayoutConstraintAxisVertical;
        colum.alignment = UIStackViewAlignmentCenter;
        
        [self addSubview:colum];
        
        [[colum youme] safe_margin: [[AAIMargin alloc] initWitht: @(74 + 64) l: @0 b: @16 r: @0]];
        
        AAILoadView *loadingView = [[AAILoadView alloc] init];
        loadingView.brandColor = brandColor;
        
        [colum aai_addArrangedSubview:^UIView * _Nonnull{
            [[loadingView youme] width: @56 height: @56];
            return loadingView;
        } space:24];

        [colum aai_addArrangedSubview:^UIView * _Nonnull{
            UILabel *label = [[UILabel alloc] init];
            label.text = text;
            label.font = [UIFont boldSystemFontOfSize:16];
            return label;
        }];
        
        [colum aai_expand];
        
        [loadingView startAnimation];
    }
    return self;
}

- (void)showInView:(UIView *)view {
    self.tag = 1379;
    [view addSubview:self];

    [[self youme] margin: [[AAIMargin alloc] initWitht: @0 l: @0 b: @0 r: @0]];
}

+ (void)dismissInView:(UIView *)view {
    UIView *hud = [view viewWithTag:1379];
    if (hud) {
        [hud removeFromSuperview];
    }
}

@end

