#import "AAIMargin.h"

@implementation AAIMargin

+ (instancetype)zero {
    return [[self alloc] initWitht:@0 l:@0 b:@0 r:@0];
}

- (instancetype)initWitht:(NSNumber* _Nullable)t
                        l:(NSNumber* _Nullable)l
                        b:(NSNumber* _Nullable)b
                        r:(NSNumber* _Nullable)r {
    if (self = [super init]) {
        self.top = t;
        self.left = l;
        self.bottom = b;
        self.right = r;
    }
    return self;
}

- (instancetype)initWithl:(NSNumber*)l r:(NSNumber*)r {
    return [self initWitht:nil l:l b:nil r:r];
}

- (instancetype)standard {
    if (self.top == nil) {
        self.top = @0;
    }
    if (self.left == nil) {
        self.left = @0;
    }

    if (self.bottom == nil) {
        self.bottom = @0;
    }

    if (self.right == nil) {
        self.right = @0;
    }

    return self;
}

@end
