//
//  AAILivenessFailureResult.h
//  AAILivenessUI
//
//  Created by advance on 2023/4/17.
//  Copyright © 2023 Advance.ai. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AAILivenessSDK/AAIVideoRecordResult.h>
#import <AAILivenessSDK/AAIDetectionConstant.h>

NS_ASSUME_NONNULL_BEGIN

/// This class is used to convert the NSDictionary errorInfo to an AAILivenessFailureResult object, which is convenient for you to process error information.
/// @since 4.0.0
__attribute__((visibility("default")))
@interface AAILivenessFailureResult : NSObject

/// @discussion
/// The error codes are as follows:
/// @code
/// TIMEOUT          // Detection timeout
/// MUTIPLE_FACE     // Multiple faces detected during the motion stage
/// FACE_MISSING     // Face is missing during the motion stage
/// MUCH_ACTION      // Multiple motions detected during the motion stage
/// USER_GIVE_UP     // The user clicked the top left back button during the detection process
/// AUTH_NETWORK_ERROR_{errorCode} // Network request failed in auth stage
/// UPLOAD_IMAGE_DATA_NETWORK_ERROR_{errorCode} // Network request failed in upload image data stage
/// CAMERA_OPEN_FAILED    // Camera open failed
/// DEVICE_NOT_SUPPORT    // No front camera
/// NO_CAMERA_PERMISSION  // No camera permission
/// LIVENESS_TYPE_NOT_FOUND // Liveness type not found. This error code occurs only if you provide an unsupported livenessType
/// ERROR_NO_PARAM // No available model parameters matched
/// MODEL_ERROR // Model error. This means that the model file is corrupted or load failed
/// UNDEFINED   // Other undefined errors
/// ...(Other server-side error codes)
/// @endcode
///
@property(nonatomic, copy, readonly) NSString *errorCode;

/// Localized error message.
@property(nonatomic, copy, readwrite) NSString *errorMsg;

/// The transaction id. Only not empty when a server-side error occurs; otherwise, it is always an empty string.
@property(nonatomic, copy, readonly) NSString *transactionId;

@property(nonatomic, copy, readwrite, nullable) NSString *rawErrorCode;

@property(nonatomic, copy, readonly) NSString *eventId;

@property(nonatomic, assign, readonly) AAILivenessStage livenessStage;

/// Convert the NSDictionary errorInfo to an AAILivenessFailureResult object.
+ (AAILivenessFailureResult *)resultWithErrorInfo:(NSDictionary *)errorInfo;

/// Get the recorded video result synchronously.  If the video recording is not enabled, this method will return nil.
///
/// @since 4.0.0
- (AAIVideoRecordResult * _Nullable)syncGetVideoRecordResult NS_SWIFT_NAME(syncGetVideoRecordResult());

@end

NS_ASSUME_NONNULL_END
