//
//  AAILivenessSuccessResult.h
//  AAILivenessSDK
//
//  Created by advance on 2022/10/28.
//  Copyright © 2022 Advance.ai. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AAILivenessSDK/AAILivenessImageData.h>
#import <AAILivenessSDK/AAIVideoRecordResult.h>
#import <AAILivenessSDK/AAIDetectionConstant.h>

NS_ASSUME_NONNULL_BEGIN

__attribute__((visibility("default")))
@interface AAILivenessSuccessResult : NSObject

/// The best quality face image captured by the SDK.
///
/// Note that the default image size is 600x600. You can call `[AAILivenessSDK configResultPictureSize:]` method to customize the size of the image.
///
/// @since 1.2.0
@property(nonatomic, strong, readonly) UIImage *img;

/// A square image containing only the face area, image size is 300x300.
/// @since 2.0.4
@property(nonatomic, strong, readonly) UIImage *fullFaceImg;

/// LivenessId. This value can be used to call the anti-spoofing api.
/// @since 1.2.0
@property(nonatomic, strong, readonly) NSString *livenessId;

/// @since 1.2.0
@property(nonatomic, strong, readonly, nullable) UIImage *highestQualityOriginSquareImage AAI_LD_UNAVAILABLE_FROM(4.0.0);

/// @since 1.2.0
@property(nonatomic, readonly) CGFloat uploadImgCostMillSeconds;

/// @since 1.2.0
@property(nonatomic, strong, nullable) NSString *transactionId;

/// @since 3.1.0
@property(nonatomic, strong, readonly) NSString *eventId;

/// Base64 string list. It will contain one image for each action, and two images of the best quality.
///
/// @warning Starting from version 3.0.4, this method is no longer available. You can use '[result getImgBase64Str]' and '[result getNearBase64Str]' methods to compose the image sequence.
///
/// @since 1.2.0
- (NSArray<NSString *> * _Nullable)imageSequenceList AAI_LD_UNAVAILABLE_FROM(3.0.4, "Using '[result getImgBase64Str]' and '[result getNearBase64Str]' methods to compose the image sequence.");

/// A list of imageData sorted in ascending order by timestamp. It will contains distant image data and near image data.
/// @since 3.0.7, 1.3.5
- (NSArray<AAILivenessImageData *> *)imageDataSequenceList AAI_LD_UNAVAILABLE_FROM(4.0.0, "Using `auditImageDataList` instead");

/// A list of audit imageData sorted in ascending order by timestamp.
///
/// @note If you want to get the audit image data list, you have to enable it by configure like this, otherwise it will return nil.
///
/// @code
/// AAILivenessConfig *livenessConfig = livenessViewController.livenessConfig;
/// livenessConfig.enableCollectAuditImages = YES;
/// @endcode
///
/// The length of this list is not fixed and depends on the maximum number of captures and the capture interval you have set.
///
/// @since 3.1.0
- (NSArray<AAILivenessImageData *> * _Nullable)auditImageDataList;

/// Return the base64 string corresponding to the 'img'(distant image) property.
///
/// Internally, this function simply converts the 'img' property to a base64 string.
///
/// @since 3.0.4
- (NSString * _Nullable)getImgBase64Str;

/// Return the base64 string corresponding to the near image with the best quality.
/// @since 3.0.4
- (NSString * _Nullable)getNearBase64Str;

/// Get the recorded video result synchronously.  If the video recording is not enabled, this method will return nil.
///
/// @since 4.0.0
- (AAIVideoRecordResult * _Nullable)syncGetVideoRecordResult NS_SWIFT_NAME(syncGetVideoRecordResult());

@end

NS_ASSUME_NONNULL_END
