//
//  AAIAuditImageConfig.h
//  AAILivenessSDK
//
//  Created by advance on 2025/5/13.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

__attribute__((visibility("default")))
@interface AAIAuditImageConfig : NSObject

/// Wheather to collect audit images. Default is NO.
///
/// @since 4.0.0
@property(nonatomic) BOOL enableCollect;

/// The capture interval for audit images. Default is 400(ms).
///
/// @since 4.0.0
@property(nonatomic) NSInteger imageCaptureInterval;

/// The maximum number of captures. Default is 20.
///
/// @since 4.0.0
@property(nonatomic) NSInteger imageMaxNumber;

/// The width of audit image. Default is 300.
///
/// @since 4.0.0
@property(nonatomic) NSInteger imageWidth;

/// The quality of audit image. Default is 30. Available values in range [30, 100].
///
/// @since 4.0.0
@property(nonatomic) NSInteger imageQuality;

/// Try capture a audit image at specific time (the relative time after the camera is launched). Default is 0(second), means no capture.
///
/// @since 4.0.0
@property(nonatomic) CGFloat relativeSecondsCaptureAfterCameraLaunched;

- (instancetype)init NS_UNAVAILABLE;

/// @since 4.0.0
+ (AAIAuditImageConfig *)defaultConfig;

@end

NS_ASSUME_NONNULL_END
