
#import "UIStackView+add.h"
#import "AAIMargin.h"
@implementation UIStackView (Add)


-(UIStackView *)aai_addArrangedSubview:(UIView *(^)(void))view {
    UIView *v = view();
    [self addArrangedSubview:v];
    return self;
}


-(UIStackView *)aai_addArrangedSubview:(UIView *(^)(void))view
                       space:(CGFloat)space {
    UIView *v = view();
    [self addArrangedSubview:v];
    
    if (@available(iOS 11.0, *)) {
        [self setCustomSpacing:space afterView:v];
    } else {
        
    }
    return self;
}

-(UIStackView *)aai_expand {
    UIView *v = [[UIView alloc] init];
    [self addArrangedSubview:v];
    return self;
}



@end
