
#import "AAIButton.h"

@interface Javen ()

@property (nonatomic, weak) UIControl *control;
@property (nonatomic, strong) void(^tap)(UIView *);

@end

@implementation Javen

- (instancetype)initWith:(UIControl *)control {
    if (self = [super init]) {
        self.control = control;
        
    }
    return self;
}


-(void)tap:(void (^)(UIView *))block {
    [self.control addTarget:self action:@selector(tapAction:) forControlEvents:UIControlEventTouchUpInside];
    self.tap = block;
}

-(void)tapAction:(UIControl *)control {
    if (self.tap) {
        self.tap(control);
    }
}

@end
    
    
    
@interface AAIButton ()
    
@property (nonatomic, strong) Javen *javen;
    
@end
    
@implementation AAIButton

-(Javen *)javen {
    if (_javen == nil) {
        Javen *jax = [[Javen alloc] initWith:self];
        _javen = jax;
    }
    return _javen;
}

@end
