// swift-tools-version: 5.6
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

let package = Package(
    name: "AAILivenessUI",
    defaultLocalization: "en",
    products: [
        // Products define the executables and libraries a package produces, making them visible to other packages.
        .library(
            name: "AAILivenessUI",
            type: .dynamic,
            targets: ["AAILivenessUI"]),
    ],
    targets: [
        .binaryTarget(
            name: "AAILivenessSDK",
            path: "Frameworks/AAILivenessSDK.xcframework"),
        
            .binaryTarget(
                name: "AAINetwork",
                url: "https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-libraries/AAINetwork/AAINetwork-V1.0.3.xcframework.zip",
                checksum: "7567c235c941c4be653eb7d024fd130e9566dd212d3062e9fab53075b9fe03df"),
        
            .target(
                name: "AAILivenessUI",
                dependencies: ["AAILivenessSDK", "AAINetwork"],
                path: "Sources",
                resources: [
                    .copy("Resource/AAIAudio.bundle"),
                    .copy("Resource/AAIImgs.xcassets"),
                    .copy("Resource/AAILanguageString.bundle"),
                    .copy("Resource/AAIModel.bundle"),
                    .process("Resource/PrivacyInfo.xcprivacy")
                ],
                
                publicHeadersPath: "Classes/include",
                cxxSettings: [
                    .headerSearchPath("Classes/AAILiveness"),
                    .headerSearchPath("Classes/Aoen"),
                    .headerSearchPath("Classes/Private")
                ]),
        .testTarget(
            name: "AAILivenessUITests",
            dependencies: ["AAILivenessUI"]),
    ]
)
