//
//  AAIAdditionalConfig.h
//  AAILivenessSDK
//
//  Created by advance on 2022/11/17.
//  Copyright © 2022 Advance.ai. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AAILivenessSDK/AAIDetectionConstant.h>

typedef NS_ENUM(NSInteger, AAILDPluginType) {
    AAILDPluginTypeOther = -1,
    AAILDPluginTypeStandard = 0,
    AAILDPluginTypeReactNative = 1,
    AAILDPluginTypeFlutter = 2,
    AAILDPluginTypeCordova = 3,
    AAILDPluginTypeXamarin = 4,
    AAILDPluginTypeKMM = 5,
};

NS_ASSUME_NONNULL_BEGIN

__attribute__((visibility("default")))
@interface AAIAdditionalConfig : NSObject

/// The color of the round border in the avatar preview area. Default is clear color.
/// @warning This property only works on version 2.x.x
///
/// @since v2.0.0
@property(nonatomic) UIColor *roundBorderColor;

/// The color of the ellipse dashed line that appears during the liveness detection. Default is white color.
/// @warning This property only works on version 2.x.x
///
/// @since v2.0.0
@property(nonatomic) UIColor *ellipseLineColor;

/// The highlight color of the ellipse border in 3D mode(near/distant mode). Default is 0x5BC413.
///
/// @since v3.0.0
@property(nonatomic, nullable) UIColor *ellipseBorderCol3D;

/// The normal color of the ellipse border in 3D mode(near/distant mode). Default is 0xF5F5F5.
///
/// @since v3.3.0
@property(nonatomic, nullable) UIColor *normalEllipseBorderCol3D;

/// The hightlight color of the inner ellipse animation line of the 3D mode(near/distant mode). Default is 0x5BC413.
///
/// @since v3.0.0
@property(nonatomic, nullable) UIColor *innerEllipseLineCol3D;

/// The difficulty of liveness detection. Default is AAIDetectionLevelNormal.
///
/// @since v2.0.1
@property(nonatomic) AAIDetectionLevel detectionLevel;

/// In versions prior to SDK v3.0.0, this value only represents the timeout duration during the preparation stage.
///
/// From SDK v3.0.0 and later, this value actually represents the timeout duration in 3D mode(near/distant mode).
/// This time duration does not include network request duration.
///
/// @warning The range of values should be [10s, 60s], default is 50s.
///
@property(nonatomic) NSInteger prepareTimeoutInterval;

/// The SDK can have different operating modes, such as silent detection mode, default mode(action mode). Default is 'AAILDOperatingModeSilent'.
@property(nonatomic, readonly) AAILDOperatingMode operatingMode;


/// Wheather to collect audit images. Default is NO.
///
/// @since v3.1.0
@property(nonatomic) BOOL enableCollectAuditImages;

/// The capture interval for audit images. Default is 400(ms).
///
/// @since v3.1.0
@property(nonatomic) NSInteger auditImageCaptureInterval;

/// The maximum number of captures. Default is 20.
///
/// @since v3.1.0
@property(nonatomic) NSInteger auditImageMaxNumber;

/// The width of audit image. Default is 300.
///
/// @since v3.1.0
@property(nonatomic) NSInteger auditImageWidth;

/// The quality of audit image. Default is 30. Available values in range [30, 100].
///
/// @since v3.1.2
@property(nonatomic) NSInteger auditImageQuality;

/// Try capture a audit image at specific time (the relative time after the camera is launched). Default is 0(second), means no capture.
///
/// @since v3.3.0
@property(nonatomic) CGFloat relativeSecondsCaptureAfterCameraLaunched;

/// Used to mark the plugin type. Default is nil. This value is used for distinguishing different plugins.
/// 
/// @since v3.4.0
@property(nonatomic) AAILDPluginType pluginType;

/// An optional string value used to conveniently query liveness detection results.
/// Call the `/liveness/generate-signature-id` API to generate this value, then assign it to
/// this field before starting a new liveness flow.
///
/// @warning The value must be unique per liveness flow. Passing a previously used value will result in a parameter error in SDK.
///  The SDK will automatically reset this field to nil after it is used.
///
/// @since v3.6.0
@property(nonatomic, nullable, copy) NSString *signatureId;

@end

NS_ASSUME_NONNULL_END
