//
//  ViewController.m
//  LivenessSDKObjCDemo
//
//  Created by advance on 2021/7/21.
//

#import "ViewController.h"
@import AAILivenessUI;
#import "AAICustomLD03Controller.h"

@interface ViewController ()
{
    NSInteger _testType;
}
@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Init SDK
    [AAILivenessSDK initWithMarket:AAILivenessMarketIndonesia];
    
    // Configure SDK
    /*
    // Set the size(width) of `img` in `AAILivenessResult`. Image size(width) should be in range [300, 1000], default image size(width) is 600(600x600).
    [AAILivenessSDK configResultPictureSize:600];
    */

    /*
    // Set whether to detect face occlusion. The default value is NO.
    [AAILivenessSDK configDetectOcclusion:YES];
    */
    
    /*
    AAIAdditionalConfig *additionalConfig = [AAILivenessSDK additionalConfig];
    // Set the color of the round border in the avatar preview area. Default is clear color.
    // additionalConfig.roundBorderColor = [UIColor colorWithRed:0.36 green:0.768 blue:0.078 alpha:1.0];

    // Set the color of the ellipse dashed line that appears during the liveness detection. Default is white color.
    // additionalConfig.ellipseLineColor = [UIColor greenColor];

    // Set the level of liveness detection. Default is AAIDetectionLevelNormal.
    // Available levels are AAIDetectionLevelEasy, AAIDetectionLevelNormal, AAIDetectionLevelHard
    // The harder it is, the stricter the verification is.
    // additionalConfig.detectionLevel = AAIDetectionLevelNormal;
    */

    
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(0, 80, [UIScreen mainScreen].bounds.size.width, 40)];
    label.text = [NSString stringWithFormat:@"SDK version: %@", [AAILivenessSDK sdkVersion]];
    [self.view addSubview:label];
    
    [self addButton:@"Default test" frame:CGRectMake(40, 140, 140, 40) action:@selector(tapSDKBtnAction)];
    [self addButton:@"CustomUI test 03" frame:CGRectMake(40, 200, 200, 40) action:@selector(tapCustomUIBtn03Action)];
}

- (void)addButton:(NSString *)title frame:(CGRect)frame action:(SEL)action
{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = frame;
    [btn setTitle:title forState:UIControlStateNormal];
    [btn setTitleColor:[UIColor redColor] forState:UIControlStateNormal];
    [btn addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn];
}

- (void)tapSDKBtnAction
{
    _testType = 0;
    
    [self showSDK];
}

- (void)tapCustomUIBtn03Action
{
    _testType = 3;
    [self showSDK];
}

- (void)showSDK
{
    // Demo: Push default liveness view controller
    if (_testType == 0) {
        [AAILivenessSDK configTicket:@"your-ticket"];
        [AAILivenessSDK configQueryId:@"your-queryId"];
        AAILivenessViewController *vc = [[AAILivenessViewController alloc] init];
        // Refer to the user guide document for additional
        // configuration options related to this view controller.
        // ...
        vc.detectionSuccessBlk = ^(AAILivenessViewController * _Nonnull rawVC, AAILivenessResult * _Nonnull result) {
            // Get livenessId
            NSString *livenessId = result.livenessId;
            UIImage *bestImg = result.img;
            CGSize size = bestImg.size;
            NSLog(@"✅:>>>>>livenessId: %@, imgSize: %.2f, %.2f", livenessId, size.width, size.height);
            // Do something... (e.g., call anti-spoofing api to get score)
            
            [rawVC.navigationController popViewControllerAnimated:YES];
        };
        // If you don't implement the `detectionFailedBlk`, the SDK will go to the `AAILivenessResultViewController` when liveness detection fails.
        // You should implement this block to go to your custom result page or process error information.
        vc.detectionFailedBlk = ^(AAILivenessViewController * _Nonnull rawVC, NSDictionary * _Nonnull errorInfo) {
           AAILivenessFailedResult *result = [AAILivenessFailedResult resultWithErrorInfo:errorInfo];
           NSLog(@"❌: Detection failed: %@, message: %@, transactionId: %@", result.errorCode, result.errorMsg, result.transactionId);
           
            BOOL retry = NO;
            if (retry) {
                // retry
               [AAILivenessSDK configTicket:@"your-new-ticket"];
               [[NSNotificationCenter defaultCenter] postNotificationName:@"kAAIRestart" object:nil];
            } else {
                // Close SDK page ...
                [rawVC.navigationController popViewControllerAnimated:YES];
            }
        };
        [self.navigationController pushViewController:vc animated:YES];
    }
    
    // Demo: Present custom liveness view controller
    if (_testType == 3) {
        [AAILivenessSDK configTicket:@"your-ticket"];
        [AAILivenessSDK configQueryId:@"your-queryId"];
        AAICustomLD03Controller *vc = [[AAICustomLD03Controller alloc] init];
        // Refer to the user guide document for additional
        // configuration options related to this view controller.
        // ...
        vc.title = @"Take a Selfie";
        vc.detectionSuccessBlk = ^(AAILivenessViewController * _Nonnull rawVC, AAILivenessResult * _Nonnull result) {
            // Get livenessId
            NSString *livenessId = result.livenessId;
            UIImage *bestImg = result.img;
            CGSize size = bestImg.size;
            NSLog(@">>>>>livenessId: %@, imgSize: %.2f, %.2f", livenessId, size.width, size.height);
            // Do something... (e.g., call anti-spoofing api to get score)

            [rawVC.presentingViewController dismissViewControllerAnimated:YES completion:nil];
        };
        // If you don't implement the `detectionFailedBlk`, the SDK will go to the `AAILivenessResultViewController` when liveness detection fails.
        // You should implement this block to go to your custom result page or process error information.
        vc.detectionFailedBlk = ^(AAILivenessViewController * _Nonnull rawVC, NSDictionary * _Nonnull errorInfo) {
           AAILivenessFailedResult *result = [AAILivenessFailedResult resultWithErrorInfo:errorInfo];
           NSLog(@"❌: Detection failed: %@, message: %@, transactionId: %@", result.errorCode, result.errorMsg, result.transactionId);
           
           // Close SDK page ...
            [rawVC.presentingViewController dismissViewControllerAnimated:YES completion:nil];
        };
        UINavigationController *navc = [[UINavigationController alloc] initWithRootViewController:vc];
        navc.navigationBarHidden = YES;
        navc.modalPresentationStyle = UIModalPresentationFullScreen;
        [self presentViewController:navc animated:YES completion:nil];
    }
}


@end
