//
//  AAIBundle.m
//
//
//  Created by loong on 2024/6/19.
//

#import "AAIBundle.h"

@implementation AAIBundle


+ (NSBundle *)currentBundle {
#ifdef SWIFTPM_MODULE_BUNDLE
    return SWIFTPM_MODULE_BUNDLE;
#else
    return [NSBundle bundleForClass:[self class]];
#endif
}

+ (NSBundle *)resourceBundle {
    // Pod integration case
    NSBundle *bundle = [NSBundle bundleWithPath:[[self currentBundle] pathForResource:@"AAILivenessResources" ofType:@"bundle"]];
    if (!bundle) {
        // Manually integration case
        bundle = [self currentBundle];
    }
    return bundle;
}

+ (NSString *)modelBundlePath {
    return [[self resourceBundle].bundlePath stringByAppendingString:@"/AAIModel.bundle"];
}

+ (NSString *)languageStringBundlePath {
    return [[self resourceBundle].bundlePath stringByAppendingString:@"/AAILanguageString.bundle"];
}

+ (NSString *)audioBundlePath {
    return [[self resourceBundle].bundlePath stringByAppendingString:@"/AAIAudio.bundle"];
}


@end
