

#import "Youme.h"

@interface Youme ()
@property (nonatomic, strong) UIView *view;
@end

@implementation Youme

-(instancetype)initWith:(UIView *)view {
    if (self = [super init]) {
        view.translatesAutoresizingMaskIntoConstraints = NO;
        self.view = view;
    }
    return self;
}

-(void)safe_margin:(AAIMargin *)margin {
    
    NSMutableArray<NSLayoutConstraint *> * arr = [[NSMutableArray alloc] initWithCapacity:4];
    
    if (@available(iOS 11.0, *)) {
        
        if (margin.top) {
            NSLayoutConstraint *top = [self.view.topAnchor constraintEqualToAnchor:self.view.superview.safeAreaLayoutGuide.topAnchor constant:[margin.top doubleValue]];
            [arr addObject: top];
        }
        
        if (margin.left) {
            NSLayoutConstraint *left = [self.view.leftAnchor constraintEqualToAnchor:self.view.superview.safeAreaLayoutGuide.leftAnchor constant:[margin.left doubleValue]];
            [arr addObject: left];
        }
        
        if (margin.bottom) {
            NSLayoutConstraint *bottom = [self.view.bottomAnchor constraintEqualToAnchor:self.view.superview.safeAreaLayoutGuide.bottomAnchor constant:-[margin.right doubleValue]];
            [arr addObject: bottom];
        }
        
        if (margin.right) {
            NSLayoutConstraint *right = [self.view.rightAnchor constraintEqualToAnchor:self.view.superview.safeAreaLayoutGuide.rightAnchor constant:-[margin.right doubleValue]];
            [arr addObject: right];
        }

        [NSLayoutConstraint activateConstraints:arr];
    }
 
}

-(void)margin:(AAIMargin *)margin {
    
    NSMutableArray<NSLayoutConstraint *> * arr = [[NSMutableArray alloc] initWithCapacity:4];
    
    if (@available(iOS 11.0, *)) {
        
        if (margin.top) {
            NSLayoutConstraint *top = [self.view.topAnchor constraintEqualToAnchor:self.view.superview.topAnchor constant:[margin.top doubleValue]];
            [arr addObject: top];
        }
        
        if (margin.left) {
            NSLayoutConstraint *left = [self.view.leftAnchor constraintEqualToAnchor:self.view.superview.leftAnchor constant:[margin.left doubleValue]];
            [arr addObject: left];
        }
        
        if (margin.bottom) {
            NSLayoutConstraint *bottom = [self.view.bottomAnchor constraintEqualToAnchor:self.view.superview.bottomAnchor constant:-[margin.right doubleValue]];
            [arr addObject: bottom];
        }
        
        if (margin.right) {
            NSLayoutConstraint *right = [self.view.rightAnchor constraintEqualToAnchor:self.view.superview.rightAnchor constant:-[margin.right doubleValue]];
            [arr addObject: right];
        }

        [NSLayoutConstraint activateConstraints:arr];
    }
 
}



-(void)width:(NSNumber * _Nullable)w
        height:(NSNumber * _Nullable)h {
    if (w) {
        [self.view.widthAnchor constraintEqualToConstant:[w doubleValue]].active = YES;
    }
    
    if (h) {
        [self.view.heightAnchor constraintEqualToConstant:[h doubleValue]].active = YES;
    }
}


@end
