var exec = require('cordova/exec');

exports.initSDK = function (accessKey, secretKey, market) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'initSDK', [accessKey, secretKey, market]);
}

exports.initSDKWithLicenseAndMarket = function (license, market, callback) {
    exec(callback, null, 'AAIIOSLivenessDetectionPlugin', 'initSDKWithLicenseAndMarket', [license, market]);
}

exports.getSdkVersion = function (callback) {
    exec(callback, null, 'AAIIOSLivenessDetectionPlugin', 'SDKVersion', null);
}

exports.setDetectionActions = function (detectionActions) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configDetectionActions', [detectionActions]);
}

exports.setUserId = function (userId) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configUserId', [userId]);
}

exports.recordUserGiveUp = function (recordUserGiveUp) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'recordUserGiveUp', [recordUserGiveUp]);
}

exports.setAuditImageConfig = function (enableCollect, captureInterval, maxNumber, imageWidth, imageQuality) {
    var config = {
        enableCollect: enableCollect || false,
        captureInterval: captureInterval || 400,
        maxNumber: maxNumber || 10,
        imageWidth: imageWidth || 400,
        imageQuality: imageQuality || 30
    }
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'setAuditImageConfig', [config]);
}

exports.setVideoRecorderConfig = function (enableRecord, maxDuration) {
    var config = {
        enableRecord: enableRecord || false,
        maxDuration: maxDuration || 60
    }
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'setVideoRecorderConfig', [config]);
}

exports.setDetectOcclusion = function (detectOcclusion) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configDetectOcclusion', [detectOcclusion]);
}

exports.setPlayPromptAudio = function (playPromptAudio) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configPlayPromptAudio', [playPromptAudio]);
}

exports.setShowAnimationImgs = function (showAnimationImgs) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configShowAnimationImgs', [showAnimationImgs]);
}

exports.showHUD = function (showHUD) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'showHUD', [showHUD]);
}

exports.setAvatarPreviewWidth = function (avatarPreviewWidth) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configAvatarPreviewWidth', [avatarPreviewWidth]);
}

exports.setAvatarPreviewMarginTop = function (avatarPreviewMarginTop) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configAvatarPreviewMarginTop', [avatarPreviewMarginTop]);
}

exports.setLanguage = function (language) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configLanguage', [language]);
}

exports.setActionTimeoutInterval = function (actionTimeoutInterval) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configActionTimeoutInterval', [actionTimeoutInterval]);
}

exports.setPrepareTimeoutInterval = function (prepareTimeoutInterval) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configPrepareTimeoutInterval', [prepareTimeoutInterval]);
}

exports.setDetectionLevel = function (detectionLevel) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configDetectionLevel', [detectionLevel]);
}

exports.setRoundBoderColor = function (color) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configRoundBoderColor', [color]);
}

exports.setEllipseBorderCol3D = function (color) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configEllipseBorderCol3D', [color]);
}

exports.setInnerEllipseLineCol3D = function (color) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configInnerEllipseLineCol3D', [color]);
}

exports.setNormalEllipseBorderCol3D = function (color) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configNormalEllipseBorderCol3D', [color]);
}

exports.setHudBrandColor = function (color) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configHudBrandColor', [color]);
}

exports.setSignatureId = function (signatureId) {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'configSignatureId', [color]);
}

var internalCallbackMap = {
    onCameraPermissionDenied: null,
    onDetectionReady: null,
    onDetectionTypeChanged: null,
    onDetectionComplete: null,
    onDetectionFailed: null,
    onLivenessViewBeginRequest: null,
    onLivenessViewRequestFailed: null,
    onLivenessViewEndRequest: null,
}

var internalSDKEventCallback = {
    onCameraPermission: function(errorInfo) {
        if (errorInfo && !errorInfo.authed) {
            // Permission denied
            // {"key": "xxx", "message": "xxx"}
            if (internalCallbackMap.onCameraPermissionDenied) {
                internalCallbackMap.onCameraPermissionDenied(errorInfo.key, errorInfo.message)
            }
        }
    },
    onDetectionReady: function(info) {
        // console.log('onDetectionReady: ', info)
        if (internalCallbackMap.onDetectionReady) {
            internalCallbackMap.onDetectionReady(info.key, info.state)
        }
    },
    onDetectionTypeChanged: function(info) {
        // {"key": "xxx", "state": "xxx"}
        // console.log('onDetectionTypeChanged: ', info)
        if (internalCallbackMap.onDetectionTypeChanged) {
            internalCallbackMap.onDetectionTypeChanged(info.key, info.state)
        }
    },
    onDetectionComplete: function(info) {
        // {"livenessId": "xxx", "img": "xxx"}
        if (internalCallbackMap.onDetectionComplete) {
            // Remove field "livenessId" and "img" from info
            // then save result to addtionalInfo
            var additionalInfo = Object.assign({}, info);
            delete additionalInfo.livenessId
            delete additionalInfo.img
            internalCallbackMap.onDetectionComplete(info.livenessId, info.img, additionalInfo)
        }
    },
    onDetectionFailed: function(errorInfo) {
        // Show alert view
        // {"key": "xxx", "message": "xxx"}
        if (internalCallbackMap.onDetectionFailed) {
            internalCallbackMap.onDetectionFailed(errorInfo.key, errorInfo.message, errorInfo.additionalInfo)
        }
    },
    onLivenessViewBeginRequest: function(info) {
        // Show loading view
        if (internalCallbackMap.onLivenessViewBeginRequest) {
            internalCallbackMap.onLivenessViewBeginRequest()
        }
    },
    onLivenessViewEndRequest: function(errorInfo) {
        // Close loading view
        // {"code": integer, "message": "xxx"}
        if (internalCallbackMap.onLivenessViewEndRequest) {
            internalCallbackMap.onLivenessViewEndRequest()
        }
    },
}

exports.showSDKPage = function () {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'showSDKPage', null);
}

exports.closeSDKPage = function () {
    exec(null, null, 'AAIIOSLivenessDetectionPlugin', 'closeSDKPage', null);
}

exports.onCameraPermissionDenied = function (callback) {
    internalCallbackMap.onCameraPermissionDenied = callback
}

exports.onDetectionReady = function (callback) {
    internalCallbackMap.onDetectionReady = callback
}

exports.onDetectionTypeChanged = function (callback) {
    internalCallbackMap.onDetectionTypeChanged = callback
}

exports.onDetectionComplete = function (callback) {
    internalCallbackMap.onDetectionComplete = callback
}

exports.onDetectionFailed = function (callback) {
    internalCallbackMap.onDetectionFailed = callback
}

exports.onLivenessViewBeginRequest = function (callback) {
    internalCallbackMap.onLivenessViewBeginRequest = callback
}

exports.onLivenessViewEndRequest = function (callback) {
    internalCallbackMap.onLivenessViewEndRequest = callback
}

exports.sdkEventCallback = function (eventInfo) {
    internalSDKEventCallback[eventInfo.name](eventInfo.body)
}

exports.MARKET = {
    Indonesia: 'AAILivenessMarketIndonesia',
    India: 'AAILivenessMarketIndia',
    Philippines: 'AAILivenessMarketPhilippines',
    Vietnam: 'AAILivenessMarketVietnam',
    Thailand: 'AAILivenessMarketThailand',
    Mexico: 'AAILivenessMarketMexico',
    Malaysia: 'AAILivenessMarketMalaysia',
    Pakistan: 'AAILivenessMarketPakistan',
    Nigeria: 'AAILivenessMarketNigeria',
    Colombia: 'AAILivenessMarketColombia',
    LAOS: 'AAILivenessMarketLAOS',
    Cambodia: 'AAILivenessMarketCambodia',
    Singapore: 'AAILivenessMarketSingapore',
    Canada: 'AAILivenessMarketCanada',
    America: 'AAILivenessMarketAmerica',
    UnitedKingdom: 'AAILivenessMarketUnitedKingdom',
    BPS: 'AAILivenessMarketBPS',
}

exports.ACTION = {
    Mouth: 'AAIDetectionTypeMouth',
    Blink: 'AAIDetectionTypeBlink',
    PosYaw: 'AAIDetectionTypePosYaw'
}
