/********* AAIIOSLivenessDetectionPlugin.m Cordova Plugin Implementation *******/

#import <Cordova/CDV.h>
#import <AAILivenessSDK/AAILivenessSDK.h>
@import AAILivenessUI;

@interface AAICustomLivenessViewController: AAILivenessViewController
@property (nonatomic) CGFloat avatarPreviewWidth;
@property (nonatomic) CGFloat avatarPreviewMarginTop;
@end
@implementation AAICustomLivenessViewController
- (void)livenessWrapViewDidLoad:(AAILivenessWrapView *)wrapView
{
    [super livenessWrapViewDidLoad:wrapView];

    //Custom preview area margin top
    CGFloat tempAvatarPreviewMarginTop = _avatarPreviewMarginTop;
    if (tempAvatarPreviewMarginTop > 0) {
        wrapView.configAvatarPreviewMarginTop = ^CGFloat(CGRect wrapViewFrame) {
            return tempAvatarPreviewMarginTop;
        };
    }
    
    //Custom preview area width
    CGFloat tempAvatarPreviewWidth = _avatarPreviewWidth;
    if (tempAvatarPreviewWidth > 0) {
        wrapView.configAvatarPreviewWidth = ^CGFloat(CGRect wrapViewFrame) {
            return tempAvatarPreviewWidth;
        };
    }
}

- (void)tapBackBtnAction
{
    [self.presentingViewController dismissViewControllerAnimated:YES completion:nil];
}

@end

@interface AAIIOSLivenessDetectionPlugin : CDVPlugin
{
  // Member variables go here.
    NSArray *_detectionActions;
    BOOL _showHUD;
    CGFloat _avatarPreviewWidth;
    CGFloat _avatarPreviewMarginTop;
    NSString *_language;
    NSInteger _prepareTimeoutInterval;
    NSInteger _actionTimeoutInterval;
    UIColor *_hudBrandColor;

    BOOL _playPromptAudio;
    BOOL _showAnimationImgs;
    BOOL _recordUserGiveUp;
}

//init method
- (void)initSDK:(CDVInvokedUrlCommand*)command;
- (void)initSDKWithLicenseAndMarket:(CDVInvokedUrlCommand*)command;
- (void)showSDKPage:(CDVInvokedUrlCommand*)command;

//getter settter
- (void)SDKVersion:(CDVInvokedUrlCommand*)command;
- (void)configDetectionActions:(CDVInvokedUrlCommand*)command;
- (void)configUserId:(CDVInvokedUrlCommand*)command;
- (void)configDetectOcclusion:(CDVInvokedUrlCommand*)command;
- (void)showHUD:(CDVInvokedUrlCommand*)command;
- (void)configAvatarPreviewWidth:(CDVInvokedUrlCommand*)command;
- (void)configAvatarPreviewMarginTop:(CDVInvokedUrlCommand*)command;
- (void)configLanguage:(CDVInvokedUrlCommand*)command;
- (void)configPrepareTimeoutInterval:(CDVInvokedUrlCommand*)command;
- (void)configActionTimeoutInterval:(CDVInvokedUrlCommand*)command;

- (void)configPlayPromptAudio:(CDVInvokedUrlCommand*)command;
- (void)configShowAnimationImgs:(CDVInvokedUrlCommand*)command;

@end

@implementation AAIIOSLivenessDetectionPlugin

- (void)pluginInitialize
{
    [super pluginInitialize];
    
    _detectionActions = nil;
    _showHUD = YES;
    _playPromptAudio = YES;
    _showAnimationImgs = YES;
    _recordUserGiveUp = NO;
    _hudBrandColor = nil;

    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(emitEventInternal:) name:@"AAILivenessSDKEventNotify" object:nil];
}

- (void)emitEventInternal:(NSNotification *)notification
{
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:notification.object options:NSJSONWritingFragmentsAllowed error:nil] ;
    NSString *jsonStr = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
    NSString *callbackJsStr = [NSString stringWithFormat:@"cordova.plugins.AAIIOSLivenessDetectionPlugin.sdkEventCallback(%@)", jsonStr];
    [self.commandDelegate evalJs:callbackJsStr];
}

- (AAILivenessMarket)marketWithStr:(NSString *)marketStr
{
    NSDictionary *map = @{
        @"AAILivenessMarketIndonesia": @(AAILivenessMarketIndonesia),
        @"AAILivenessMarketIndia": @(AAILivenessMarketIndia),
        @"AAILivenessMarketPhilippines": @(AAILivenessMarketPhilippines),
        @"AAILivenessMarketVietnam": @(AAILivenessMarketVietnam),
        @"AAILivenessMarketThailand": @(AAILivenessMarketThailand),
        @"AAILivenessMarketMexico": @(AAILivenessMarketMexico),
        @"AAILivenessMarketMalaysia": @(AAILivenessMarketMalaysia),
        @"AAILivenessMarketPakistan": @(AAILivenessMarketPakistan),
        @"AAILivenessMarketNigeria": @(AAILivenessMarketNigeria),
        @"AAILivenessMarketColombia": @(AAILivenessMarketColombia),
        @"AAILivenessMarketLAOS": @(AAILivenessMarketLAOS),
        @"AAILivenessMarketCambodia": @(AAILivenessMarketCambodia),
        @"AAILivenessMarketSingapore": @(AAILivenessMarketSingapore),
        @"AAILivenessMarketCanada": @(AAILivenessMarketCanada),
        @"AAILivenessMarketAmerica": @(AAILivenessMarketAmerica),
        @"AAILivenessMarketUnitedKingdom": @(AAILivenessMarketUnitedKingdom),
        @"AAILivenessMarketBPS": @(AAILivenessMarketBPS)
    };
    return (AAILivenessMarket)([map[marketStr] integerValue]);
}


//init method(deprecated)
- (void)initSDK:(CDVInvokedUrlCommand*)command
{
    NSString *accessKey = [command.arguments objectAtIndex:0];
    NSString *secretKey = [command.arguments objectAtIndex:1];
    NSString *marketStr = [command.arguments objectAtIndex:2];
    
    AAILivenessMarket market = [self marketWithStr:marketStr];
    [AAILivenessSDK initWithAccessKey:accessKey secretKey:secretKey market:market];
}


//init method(recommend)
- (void)initSDKWithLicenseAndMarket:(CDVInvokedUrlCommand*)command
{
    NSString *licenseStr = [command.arguments objectAtIndex:0];
    NSString *marketStr = [command.arguments objectAtIndex:1];

    AAILivenessMarket market = [self marketWithStr:marketStr];
    [AAILivenessSDK initWithMarket: market];

    NSString *result = [AAILivenessSDK configLicenseAndCheck:licenseStr];
    CDVPluginResult *pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:result];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}

//getter settter
- (void)SDKVersion:(CDVInvokedUrlCommand*)command
{
    NSString *sdkVersion = [AAILivenessSDK sdkVersion];
    CDVPluginResult *pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:sdkVersion];

    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}

- (void)configDetectionActions:(CDVInvokedUrlCommand*)command
{
    _detectionActions = [command argumentAtIndex:0 withDefault:nil andClass:[NSArray class]];
}

- (void)configUserId:(CDVInvokedUrlCommand*)command
{
    NSString *userId = [command.arguments objectAtIndex:0];
    [AAILivenessSDK configUserId:userId];
}

- (void)setAuditImageConfig:(CDVInvokedUrlCommand*)command
{
    NSDictionary *config = [command.arguments objectAtIndex:0];
    // 'config' contain follow keys:
    //   enableCollect
    //   captureInterval
    //   maxNumber
    //   imageWidth
    //   imageQuality

    // Check if 'config' is null or NSNull class
    if (config == nil || [config isKindOfClass:[NSNull class]]) {
        // Just disable collect audit images
        AAIAdditionalConfig *additionalConfig = [AAILivenessSDK additionalConfig];
        additionalConfig.enableCollectAuditImages = NO;
    } else if ([config isKindOfClass:[NSDictionary class]]){
        AAIAdditionalConfig *additionalConfig = [AAILivenessSDK additionalConfig];
        NSNumber *enableCollectObj = config[@"enableCollect"];
        if ([enableCollectObj isKindOfClass:[NSNumber class]]) {
            additionalConfig.enableCollectAuditImages = [enableCollectObj boolValue];
        }
        
        NSNumber *captureIntervalObj = config[@"captureInterval"];
        if ([captureIntervalObj isKindOfClass:[NSNumber class]]) {
            additionalConfig.auditImageCaptureInterval = [captureIntervalObj integerValue];
        }

        NSNumber *maxNumberObj = config[@"maxNumber"];
        if ([maxNumberObj isKindOfClass:[NSNumber class]]) {
            additionalConfig.auditImageMaxNumber = [maxNumberObj integerValue];
        }

        NSNumber *imageWidthObj = config[@"imageWidth"];
        if ([imageWidthObj isKindOfClass:[NSNumber class]]) {
            additionalConfig.auditImageWidth = [imageWidthObj floatValue];
        }

        NSNumber *imageQualityObj = config[@"imageQuality"];
        if ([imageQualityObj isKindOfClass:[NSNumber class]]) {
            additionalConfig.auditImageQuality = [imageQualityObj integerValue];
        }
    }
}

- (void)setVideoRecorderConfig:(CDVInvokedUrlCommand*)command
{
    NSDictionary *config = [command.arguments objectAtIndex:0];
    // 'config' contain follow keys:
    //   enableRecord
    //   maxDuration
   
    // Check if 'config' is null or NSNull class
    if (config == nil || [config isKindOfClass:[NSNull class]]) {
        // Just disable record video
        [AAILivenessSDK configVideo: NULL];
    } else if ([config isKindOfClass:[NSDictionary class]]) {
        NSNumber *enableRecordObj = config[@"enableRecord"];
        if ([enableRecordObj isKindOfClass:[NSNumber class]]) {
            BOOL enableRecord = [enableRecordObj boolValue];
            if (enableRecord) {
                AAIVideoConfig *vConfig = [AAIVideoConfig defaultConfig];
                NSNumber *maxDurationObj = config[@"maxDuration"];
                if ([maxDurationObj isKindOfClass:[NSNumber class]]) {
                    vConfig.maxRecordDuration = [maxDurationObj integerValue];
                }
                [AAILivenessSDK configVideo:vConfig];
            } else {
                [AAILivenessSDK configVideo: NULL];
            }
        }
        
    }
}

- (void)recordUserGiveUp:(CDVInvokedUrlCommand*)command
{
    _recordUserGiveUp = [[command argumentAtIndex:0 withDefault:@(NO) andClass:[NSNumber class]] boolValue];
}

- (void)configDetectOcclusion:(CDVInvokedUrlCommand*)command
{
    BOOL detectOcc = [[command argumentAtIndex:0 withDefault:@(NO) andClass:[NSNumber class]] boolValue];
    [AAILivenessSDK configDetectOcclusion:detectOcc];
}

- (void)configAvatarPreviewWidth:(CDVInvokedUrlCommand*)command
{
    _avatarPreviewWidth = [[command argumentAtIndex:0 withDefault:@(0) andClass:[NSNumber class]] floatValue];
}

- (void)configAvatarPreviewMarginTop:(CDVInvokedUrlCommand*)command
{
    _avatarPreviewMarginTop = [[command argumentAtIndex:0 withDefault:@(0) andClass:[NSNumber class]] floatValue];
}

- (void)configPlayPromptAudio:(CDVInvokedUrlCommand*)command
{
    NSInteger value = [[command argumentAtIndex:0 withDefault:@(1) andClass:[NSNumber class]] integerValue];
    if (value == 1) {
        _playPromptAudio = YES;
    } else {
        _playPromptAudio = NO;
    }
}

- (void)configShowAnimationImgs:(CDVInvokedUrlCommand*)command
{
    NSInteger value = [[command argumentAtIndex:0 withDefault:@(1) andClass:[NSNumber class]] integerValue];
    if (value == 1) {
        _showAnimationImgs = YES;
    } else {
        _showAnimationImgs = NO;
    }
}

- (void)showHUD:(CDVInvokedUrlCommand*)command
{
     NSInteger value = [[command argumentAtIndex:0 withDefault:@(1) andClass:[NSNumber class]] integerValue];
     if (value == 1) {
         _showHUD = YES;
     } else {
         _showHUD = NO;
     }
}

- (void)configLanguage:(CDVInvokedUrlCommand*)command
{
    NSString *value = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    _language = value;
}

- (void)configPrepareTimeoutInterval:(CDVInvokedUrlCommand*)command
{
    NSInteger value = [[command argumentAtIndex:0 withDefault:@(10) andClass:[NSNumber class]] integerValue];
    _prepareTimeoutInterval = value;
}

- (void)configActionTimeoutInterval:(CDVInvokedUrlCommand*)command
{
    NSInteger value = [[command argumentAtIndex:0 withDefault:@(10) andClass:[NSNumber class]] integerValue];
    _actionTimeoutInterval = value;
}

- (void)configDetectionLevel:(CDVInvokedUrlCommand*)command
{
    NSString *level = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    if (level) {
        AAIDetectionLevel detectionLevel = AAIDetectionLevelNormal;
        NSString *lowerStr = [level lowercaseString];

        if ([lowerStr isEqualToString:@"easy"]) {
            detectionLevel = AAIDetectionLevelEasy;
        } else if ([lowerStr isEqualToString:@"normal"]) {
            detectionLevel = AAIDetectionLevelNormal;
        } else if ([lowerStr isEqualToString:@"hard"]) {
            detectionLevel = AAIDetectionLevelHard;
        } 
        AAIAdditionalConfig *additionalConfig = [AAILivenessSDK additionalConfig];
        additionalConfig.detectionLevel = detectionLevel;
    }
}

- (void)configRoundBoderColor:(CDVInvokedUrlCommand*)command
{
    NSString *roundBorderColorObj = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    if (roundBorderColorObj) {
        UIColor *tmpColor = [self colorWithHexRGBStr: roundBorderColorObj];
        if (tmpColor) {
            AAIAdditionalConfig *config = [AAILivenessSDK additionalConfig];
            config.roundBorderColor = tmpColor;
        }
    }
}

- (void)configEllipseLineColor:(CDVInvokedUrlCommand*)command
{
    NSString *ellipseLineColorObj = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    if (ellipseLineColorObj) {
        UIColor *tmpColor = [self colorWithHexRGBStr: ellipseLineColorObj];
        if (tmpColor) {
            AAIAdditionalConfig *config = [AAILivenessSDK additionalConfig];
            config.ellipseLineColor = tmpColor;
        }
    }
}

- (void)configEllipseBorderCol3D:(CDVInvokedUrlCommand*)command
{
    NSString *colorObj = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    if (colorObj) {
        UIColor *tmpColor = [self colorWithHexRGBStr: colorObj];
        if (tmpColor) {
            AAIAdditionalConfig *config = [AAILivenessSDK additionalConfig];
            config.ellipseBorderCol3D = tmpColor;
        }
    }
}

- (void)configInnerEllipseLineCol3D:(CDVInvokedUrlCommand*)command
{
    NSString *colorObj = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    if (colorObj) {
        UIColor *tmpColor = [self colorWithHexRGBStr: colorObj];
        if (tmpColor) {
            AAIAdditionalConfig *config = [AAILivenessSDK additionalConfig];
            config.innerEllipseLineCol3D = tmpColor;
        }
    }
}

- (void)configNormalEllipseBorderCol3D:(CDVInvokedUrlCommand*)command
{
    NSString *colorObj = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    if (colorObj) {
        UIColor *tmpColor = [self colorWithHexRGBStr: colorObj];
        if (tmpColor) {
            AAIAdditionalConfig *config = [AAILivenessSDK additionalConfig];
            config.normalEllipseBorderCol3D = tmpColor;
        }
    }
}

- (void)configHudBrandColor:(CDVInvokedUrlCommand*)command
{
    NSString *colorObj = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    if (colorObj) {
        UIColor *tmpColor = [self colorWithHexRGBStr: colorObj];
        if (tmpColor) {
            _hudBrandColor = tmpColor;
        }
    }
}

- (void)configSignatureId:(CDVInvokedUrlCommand*)command
{
    NSString *signatureId = [command argumentAtIndex:0 withDefault:nil andClass:[NSString class]];
    if (signatureId) {
        AAIAdditionalConfig *config = [AAILivenessSDK additionalConfig];
        config.signatureId = signatureId;
    }
}

- (UIColor *)colorWithHexRGBStr:(NSString *)hexRGBStr
{   
    if (hexRGBStr == nil) {
        return nil;
    }

    if (hexRGBStr.length != 7 && hexRGBStr.length != 9) {
        NSLog(@"Unsupport hexRGBStr: %@", hexRGBStr);
        return nil;
    }

    // #RRGGBB
    if (hexRGBStr.length == 7) {
        NSString *tmpStr = [hexRGBStr substringFromIndex:1];
        long rgbValue = strtol(tmpStr.UTF8String, NULL, 16);
        CGFloat r = ((rgbValue & 0xFF0000) >> 16)/255.0;
        CGFloat g = ((rgbValue & 0xFF00) >> 8)/255.0;
        CGFloat b = (rgbValue & 0xFF)/255.0;
        return [UIColor colorWithRed:r green:g blue:b alpha:1];
    }
    
    // #RRGGBBAA
    if (hexRGBStr.length == 9) {
        NSString *tmpStr = [hexRGBStr substringFromIndex:1];
        long rgbaValue = strtol(tmpStr.UTF8String, NULL, 16);
        CGFloat r = ((rgbaValue & 0xFF000000) >> 24)/255.0;
        CGFloat g = ((rgbaValue & 0xFF0000) >> 16)/255.0;
        CGFloat b = ((rgbaValue & 0xFF00) >> 8)/255.0;
        CGFloat a = (rgbaValue & 0xFF)/255.0;
        return [UIColor colorWithRed:r green:g blue:b alpha:a];
    }
    
    return nil;
}

- (void)showSDKPage:(CDVInvokedUrlCommand*)command
{
    AAIAdditionalConfig *additionalConfig = [AAILivenessSDK additionalConfig];
    additionalConfig.pluginType = AAILDPluginTypeCordova;

    AAICustomLivenessViewController *vc = [[AAICustomLivenessViewController alloc] init];
    if (_detectionActions) {
        vc.detectionActions = _detectionActions;
    }
    vc.showHUD = _showHUD;
    vc.avatarPreviewMarginTop =  _avatarPreviewMarginTop;
    vc.avatarPreviewWidth = _avatarPreviewWidth;
    vc.language = _language;
    vc.playAudio = _playPromptAudio;
    vc.showAnimationImg = _showAnimationImgs;
    vc.recordUserGiveUp = _recordUserGiveUp;
    if (_prepareTimeoutInterval > 0) {
        vc.prepareTimeoutInterval = _prepareTimeoutInterval;
    }
    
    if (_actionTimeoutInterval > 0) {
        vc.actionTimeoutInterval = _actionTimeoutInterval;
    }

    if (_hudBrandColor) {
        vc.hudBrandColor = _hudBrandColor;
    }
    vc.cameraPermissionDeniedBlk = ^(AAILivenessViewController *rawVC) {
        // detection failed callback
        NSString *state = [AAILivenessUtil localStrForKey:@"no_camera_permission"];
        NSDictionary *errorInfo = @{@"key": @"no_camera_permission", @"message": state, @"authed": @(NO)};
        [self postNoticationToPlugin:@"onCameraPermission" body:errorInfo];
    };

    vc.beginRequestBlk = ^(AAILivenessViewController *rawVC) {
        // begin request callback
        [self postNoticationToPlugin:@"onLivenessViewBeginRequest" body:@{}];
    };

    vc.endRequestBlk = ^(AAILivenessViewController *rawVC, NSDictionary *error) {
        // end request callback
        NSDictionary *errorInfo = nil;
        if (error && error.count > 0) {
            AAILivenessFailedResult *failedResult = [AAILivenessFailedResult resultWithErrorInfo:error];
            errorInfo = @{@"message": failedResult.errorMsg, @"code": failedResult.errorCode, @"transactionId": failedResult.transactionId};
        } else {
            errorInfo = @{};
        }
        [self postNoticationToPlugin:@"onLivenessViewEndRequest" body:errorInfo];
        
    };

    vc.detectionReadyBlk = ^(AAILivenessViewController *rawVC, AAIDetectionType detectionType, NSDictionary *info) {
        NSDictionary *bodyInfo = @{@"key": info[@"key"], @"message": info[@"state"]};
        [self postNoticationToPlugin:@"onDetectionReady" body:bodyInfo];
    };

    vc.detectionFailedBlk = ^(AAILivenessViewController *rawVC, NSDictionary *errorInfo) {
         // detection failed callback
       AAILivenessFailedResult *result = [AAILivenessFailedResult resultWithErrorInfo:errorInfo];
        NSDictionary *additionalInfo = @{
            @"transactionId": result.transactionId,
            @"rawErrorCode": result.rawErrorCode,
            @"eventId": result.eventId
            };
        NSDictionary *dict = @{@"key": result.errorCode, @"message": result.errorMsg, @"additionalInfo": additionalInfo};
        [self postNoticationToPlugin:@"onDetectionFailed" body:dict];
    };

    vc.detectionTypeChangedBlk = ^(AAILivenessViewController *rawVC, AAIDetectionType toDetectionType, NSDictionary *info) {
        // detection type changed callback
        NSDictionary *bodyInfo = @{@"key": info[@"key"], @"state": info[@"state"]};
        [self postNoticationToPlugin:@"onDetectionTypeChanged" body:bodyInfo];
    };

    vc.detectionSuccessBlk = ^(AAILivenessViewController *rawVC, AAILivenessResult *result) {
        NSString *base64ImgStr = [result getImgBase64Str];
        if (base64ImgStr == nil) {
            base64ImgStr = @"";
        }
        
        NSDictionary *successInfo = @{
                @"livenessId": result.livenessId,
                @"img": base64ImgStr,
                @"transactionId": (result.transactionId == nil ? @"" : result.transactionId),
                @"eventId": result.eventId
            };
        NSMutableDictionary *body = [[NSMutableDictionary alloc] initWithDictionary:successInfo];
        
        // Get video result
        AAIVideoConfig *originVConfig = [AAILivenessSDK videoConfig];
        if (originVConfig != nil && originVConfig.recordStage != AAIVideoRecordStageUnspecified) {
           NSString *videoFilePath = @"";
           AAIVideoRecordResult *videoResult = [AAILivenessSDK syncGetLatestVideoRecordResult];
           if (videoResult != nil && videoResult.code != AAIVideoRecordResultCodeFailed) {
               videoFilePath = videoResult.videoPath;
           }
           body[@"videoFilePath"] = videoFilePath;
        }
        
        [self postNoticationToPlugin:@"onDetectionComplete" body:body];
    };

    UINavigationController *navc = [[UINavigationController alloc] initWithRootViewController:vc];
    navc.navigationBarHidden = YES;
    navc.modalPresentationStyle = UIModalPresentationFullScreen;
    [self.viewController presentViewController:navc animated:YES completion:nil];
}

- (void)closeSDKPage:(CDVInvokedUrlCommand*)command
{
    [self.viewController dismissViewControllerAnimated:YES completion:nil];
}

- (void)postNoticationToPlugin:(NSString *)name body:(NSDictionary * _Nullable)body
{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSMutableDictionary *dic = [NSMutableDictionary dictionary];
        dic[@"name"] = name;
        if (body) {
            dic[@"body"] = body;
        }
        [[NSNotificationCenter defaultCenter] postNotificationName:@"AAILivenessSDKEventNotify" object:dic];
    });
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:@"AAILivenessSDKEventNotify" object:nil];
}

@end
