## Cordova aai-ios-liveness-detection-plugin(v3.6.1)

### Migration Guides
1. From version 3.1.3, the method `onLivenessViewRequestFailed` have been removed, and the parameter `errorCode`(old version called 'key') of `onDetectionFailed` has been changed, please refer to the [v3.1.3 change logs](#cl-v3-1-3) for details.

### Download SDK

See [this part](#change-logs-and-release-history) to get SDK download link.

### Installation

1. Add local plugin to your project:

    ```shell
    # remove exist plugin if needed. 
    cordova plugin remove aai-ios-liveness-detection-plugin

    cordova plugin add /path/to/guardian-liveness-detection-cordova-plugin-ios
    ```
    > If you get error like "CordovaError: Could not determine package name from output", try using a lower version of npm(e.g. `nvm install 14.19.0`).

2. Add camera usage description in `Info.plist` as bellow. Ignore this step if you have added those.
   
   ```xml
   <key>NSCameraUsageDescription</key>
   <string>Use the camera to detect the face movements</string>
   ```

### Usage
 
```javascript

document.addEventListener('deviceready', onDeviceReady, false);

function onDeviceReady() {
    document.getElementById('test-liveness-button').addEventListener('click', showLivenessView)

    // Init SDK with license and market(required)
    var plugin = cordova.plugins.AAIIOSLivenessDetectionPlugin

    // Your server needs to call openAPI to obtain license content
    var license = "your-license-content"
    /*
    Market available value are as follows:
    Indonesia
    India
    Philippines
    Vietnam
    Thailand
    Mexico
    Malaysia
    Pakistan
    Nigeria
    Colombia
    Singapore
    BPS
    */
    var market = plugin.MARKET.Indonesia
    plugin.initSDKWithLicenseAndMarket(license, market, function(result){
        document.getElementById('sdk-callback-msg').innerHTML = 'initSDKWithLicenseAndMarket:' + result
    })

    // Get SDK version (optional)
    plugin.getSdkVersion(function(version) {
        console.log(version)
        document.getElementById('test-liveness-button').innerHTML = version + '-liveness-sdk-test'
    })

    // Config SDK (optional)
    /*
    // You can also specify the motion detection sequence yourself, 
    // as the sequence and number are not fixed.
    plugin.setDetectionActions([plugin.ACTION.Blink, plugin.ACTION.Mouth])

    plugin.setAvatarPreviewWidth(250)

    plugin.setAvatarPreviewMarginTop(200)

    // If you pass false, the SDK will not display the default loading view, 
    // you need to display and close the custom loading view in 'onLivenessViewBeginRequest' and 'onLivenessViewEndRequest', respectively.
    plugin.showHUD(true)
    */

   /*
    // User binding (optional, but strongly recommended).
    // You can use this method to pass your user unique identifier to us, 
    // we will establish a mapping relationship based on the identifier。
    // It is helpful for us to check the log when encountering problems.
    plugin.setUserId("your-user-id")
   */

   /*
    // Set whether to detect face occlusion.(optional)
    // If this value is set to true, SDK will detect face occlusion before entering the action. The default value is false.
    plugin.setDetectOcclusion(true)
   */

    /*
    /// Set the timeout for action detection, default is 10s.
    ///
    /// Note that this value represents the timeout for an action,
    /// not the total timeout for all actions.
    plugin.setActionTimeoutInterval(10)
    */

   /*
   /// Set the timeout for prepare stage, default is 10s.
   ///
   /// This value refers to the time from when the sdk page is displayed to when the motion detection is ready.
   /// For example, after the sdk page is presented, if the user does not hold the phone upright or put the face in the detection area,
   /// and continues in this state for a certain period of time, then the `onDetectionFailed` will be called,
   /// and the value of the "key" is "fail_reason_prepare_timeout".
   plugin.setPrepareTimeoutInterval(10)
   */
   
   /*
   /// Specify which language to use for the SDK. If this value is not set,
   /// the system language will be used by default. If the system language is not supported,
   /// English will be used.
   ///
   /// The languages currently supported by sdk are as follows:
   /// 
   /// "en" "id"  "vi"  "zh-Hans"  "th"  "es"  "ms" "hi"
   plugin.setLanguage("en")
   */

   /*
    // Set the color of the round border in the avatar preview area. Default is clear color(#00000000).
    plugin.setRoundBoderColor("#FF0000")
   */

   /*
    // Set the color of the ellipse dashed line that appears during the liveness detection. Default is white color.
    plugin.setEllipseLineColor("#00FF00")
   */

   /*
    // Set the color of the color of the ellipse border in 3D mode(near/distant mode). Default is 0x5BC413.
    plugin.setEllipseBorderCol3D("#00FF00")
   */
    
    /*
    // The normal color of the ellipse border in 3D mode(near/distant mode). Default is #F5F5F5.
    // @since 3.3.0
    plugin.setNormalEllipseBorderCol3D("#0000FF")
    */

    /*
    // Set the color of the inner ellipse animation line of the 3D mode(near/distant mode). Default is #5BC413.
    plugin.setInnerEllipseLineCol3D("#FF0000")
   */

   /*
    // Set the color of `AAILoadingHud`. Default is #5BC413.
    // @since 3.4.0
    plugin.setHudBrandColor("#FF0000")
   */

   /*
    // Whether to allow to play prompt audio. Default is true.
    plugin.setPlayPromptAudio(true)
   */

   /*
    // Whether to display animation images. Default is true. If you set false, then animation images will be hidden.
    plugin.setShowAnimationImgs(true)
   */

   /*
    // Optional
    // If you enable this feature, the SDK will automatically upload the audit image sequence list to the server after liveness detection complete. 
    // You can obtained the 'auditImageUrl' fileld in the liveness-detection openapi response. See liveness-detection openapi for more detail.
    // 
    // The first parameter:Whether to collect audit images. Default is false.
    // The second parameter:Minimum interval time for capturing images,default interval is 400ms
    // The third parameter:Maximum number of captured images,default number is 10
    // The fourth parameter:The image width,default width is 400px
    // The fifth parameter:The image compress quality,must in [30,100],the default value is 30
    plugin.setAuditImageConfig(false,300,2,400,50)  
    */

    /*
    /// Optional
    // If you enable this feature, SDK will record video during the detection process. 
    // After the completion of the liveness process, you can retrieve the 'videoFilePath' by parse the 'additionalInfo' 
    // in 'onDetectionComplete' callback.
    // The video file format is .mp4. Please note that this video can only be obtained through the SDK and 
    // cannot be obtained from the aai backend. After using the video, it is up to you to decide whether to delete the local file.
    // 
    // The first parameter:Whether to record video. Default value is false.
    // The second parameter:The maximum recording duration, in seconds, valid range [2,60], default is 60 seconds.
    plugin.setVideoRecorderConfig(true,60)
    */
    
    /*
    /// Optional
    // Whether to mark the action of tapping back button as "USER_GIVE_UP". The default is false. If you pass true, the `onDetectionFailed`
    // will be called when the user taps the top left back button while liveneness detection is running.
    plugin.recordUserGiveUp(false)
    */
    
    /*
    /// Optional
    /// An optional string value used to conveniently query liveness detection results.
    /// Call the `/liveness/generate-signature-id` API to generate this value, then pass it to this method 
    /// before starting a new liveness flow.
    ///
    /// @warning The value must be unique per liveness flow. Passing a previously used value will result in a parameter error in SDK.
    ///
    /// @since 3.6.0
    plugin.setSignatureId("your-unique-signature-id")
    */
   
    // Config SDK callback
    configSDKCallback()
}

function configSDKCallback() {
    var plugin = cordova.plugins.AAIIOSLivenessDetectionPlugin

    //Set callback
    /* Required */
    plugin.onCameraPermissionDenied(function(key, message) {
        console.log('onCameraPermissionDenied:', key, message)
        //close liveness page
        plugin.closeSDKPage()
    })

    /* Optional */
    plugin.onDetectionReady(function(key, message) {
        console.log('onDetectionReady:', key)
    })

    /* Optional */
    plugin.onDetectionTypeChanged(function(key, message) {
        console.log('onDetectionTypeChanged:', key)
    })

    /* Required */
    plugin.onDetectionComplete(function(livenessId, base64ImgStr, additionalInfo) {
        //close liveness page
        plugin.closeSDKPage()

        console.log('onDetectionComplete:', livenessId)
        console.log('additionalInfo:', additionalInfo)
        /*
        You need to give the livenessId to your server, then your server will call the anti-spoofing api to get the score of this image.
        The default base64Img size is 300x300.

        The parameter 'additionalInfo' contains the following keys:
           - 'eventId': This used to help debug the specific cause of the error.
           - 'transactionId': This is used to help debug the specific cause of the server side error.
           - 'videoFilePath': The video file path, if you enable the video recording feature, otherwise this key will not exist.
        */
    })

    /* Required */
    plugin.onDetectionFailed(function(errorCode, message, additionalInfo) {
        //close liveness page
        plugin.closeSDKPage()

        console.log('onDetectionFailed:', errorCode, message)
        console.log('additionalInfo:', additionalInfo)
    })

    /* Optional */
    plugin.onLivenessViewBeginRequest(function() {
        console.log('onLivenessViewBeginRequest')
    })

    /* Optional */
    plugin.onLivenessViewEndRequest(function() {
        console.log('onLivenessViewEndRequest')
    })
}

function showLivenessView() {
    //Show SDK Page.
    /*
    By default, this page is displayed modally.
    If you need other presentation type, please modify the 'showSDKPage:' method in 'AAIIOSLivenessDetectionPlugin.m'
    */
   cordova.plugins.AAIIOSLivenessDetectionPlugin.showSDKPage()
}

```

### Error code

The `errorCode` values of `onDetectionFailed` are as follows:

| errorCode | raw native sdk code | Description |
| :--: | :--: | :--: |
| PREPARE_TIMEOUT | fail_reason_prepare_timeout | Timeout during the preparation stage |
| ACTION_TIMEOUT | fail_reason_timeout | Timeout during the motion stage |
| MUTI_FACE | fail_reason_muti_face | Multiple faces detected during the motion stage |
| FACE_MISSING | fail_reason_facemiss_blink_mouth |Face is missing during the motion stage(blink or open mouth)|
| FACE_MISSING | fail_reason_facemiss_pos_yaw | Face is missing during the motion stage(pos yaw) |
| MUCH_ACTION | fail_reason_much_action | Multiple motions detected during the motion stage |
| USER_GIVE_UP | user_give_up | The user clicked the top left back button during the detection process |
| NO_RESPONSE |  | Network request failed |
| DEVICE_NOT_SUPPORT | device_not_support | The front camera of this device cannot be opened |
| UNDEFINED | | Other undefined errors |
| ...(Other server side error codes) | | |

### Change logs and release history

#### v3.6.3 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.6.3/iOS-Liveness-Detection-(Cordova)-V3.6.3.zip)
##### Update
1. Sync native SDK.

#### v3.6.2 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.6.2/iOS-Liveness-Detection-(Cordova)-V3.6.2.zip)
##### Update
1. Sync native SDK.

#### v3.6.1 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.6.1/iOS-Liveness-Detection-(Cordova)-V3.6.1.zip)
##### Update
1. Sync native SDK.

#### v3.6.0 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.6.0/iOS-Liveness-Detection-(Cordova)-V3.6.0.zip)
##### Update
1. Sync native SDK.
2. Add `setSignatureId` method.

#### v3.5.0 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.5.0/iOS-Liveness-Detection-(Cordova)-V3.5.0.zip)
##### Update
1. Sync native SDK.

#### v3.4.1 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.4.1/iOS-Liveness-Detection-(Cordova)-V3.4.1.zip)
##### Update
1. Sync native SDK.

#### v3.4.0 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.4.0/iOS-Liveness-Detection-(Cordova)-V3.4.0.zip)
##### Update
1. Sync native SDK.
2. Add `setHudBrandColor` method, which is used to set the color of `AAILoadingHud`. The default is #5BC413.

#### v3.3.0 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.3.0/iOS-Liveness-Detection-(Cordova)-V3.3.0.zip)
##### Update
1. Sync native SDK.

##### New Features
1. Added `setNormalEllipseBorderCol3D` method, which is used to set the normal color of the ellipse border in 3D mode(near/distant mode). The default is 0xF5F5F5.
If you want to maintain the previous interaction effect, you can call the following codes:
    ```javascript
    // Other configurations
    ...
    plugin.setEllipseBorderCol3D("#5BC413")
    plugin.setNormalEllipseBorderCol3D("#5BC413")
    ```

#### <span id="cl-v3-1-3">v3.1.3</span> [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.1.3/iOS-Liveness-Detection-(Cordova)-V3.1.3.zip)

##### Breaking Changes

1. Remove the callback method `onLivenessViewRequestFailed`, please use `onDetectionFailed` to handle the user's give up action and network request failed.
2. The `errorCode` of `onDetectionFailed` has been changed, please refer to the [Error code](#error-code) for details.

##### New Features
1. Added `additionalInfo` parameter to `onDetectionFailed` method, which contains the following keys:
   - "eventId": This is used to help debug the specific cause of the error.
   - "rawErrorCode": The native sdk side raw error code.
   - "transactionId": This is used to help debug the specific cause of the server side error.
2. Added `additionalInfo` parameter to `onDetectionComplete` method, which contains the following keys:
   - "eventId": This is used to help debug the specific cause of the error.
   - "transactionId": This is used to help debug the specific cause of the server side error.
   - "videoFilePath": The video file path, if you enable the video recording feature, otherwise this key will not exist.
3. Added `recordUserGiveUp` method, which is used to mark the action of tapping back button as "USER_GIVE_UP". The default is false. If you pass true, the `onDetectionFailed` will be called when the user taps the top left back button while liveneness detection is running.
4. Added method `setAuditImageConfig` and `setVideoRecorderConfig` to support collecting audit images and recording video during the detection process.

##### Update
1. Sync native SDK.

#### v3.1.2 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.1.2/iOS-Liveness-Detection-(Cordova)-V3.1.2.zip)
1. Sync native SDK.

#### v3.1.1 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.1.1/iOS-Liveness-Detection-(Cordova)-V3.1.1.zip)
1. Sync native SDK.

#### v3.1.0 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.1.0/iOS-Liveness-Detection-(Cordova)-V3.1.0.zip)
1. Sync native SDK.

#### v3.0.7 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.0.7/iOS-Liveness-Detection-(Cordova)-V3.0.7.zip)
1. Sync native SDK.
2. Support market `BPS`.
3. Add methods `setEllipseBorderCol3D` and `setInnerEllipseLineCol3D`.

#### v3.0.5 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.0.5/iOS-Liveness-Detection-(Cordova)-V3.0.5.zip)
1. Sync native SDK.
2. Upgrade AAINetwork module to 1.0.2.

#### v3.0.4 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.0.4/iOS-Liveness-Detection-(Cordova)-V3.0.4.zip)
1. Sync native SDK.

#### v3.0.3 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.0.3/iOS-Liveness-Detection-(Cordova)-V3.0.3.zip)
1. Sync native SDK.

#### v3.0.2 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.0.2/iOS-Liveness-Detection-(Cordova)-V3.0.2.zip)
1. Sync native SDK.

#### v3.0.0 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/3.0.0/iOS-Liveness-Detection-(Cordova)-V3.0.0.zip)
1. Sync native SDK.
2. From version 3.0.0, motion detection has been removed, so the properties and methods related to motion detection will not have any effect.

#### v2.0.7 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/2.0.7/iOS-Liveness-Detection-(Cordova)-V2.0.7.zip)
1. Sync native SDK.

#### v2.0.6 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/2.0.6/iOS-Liveness-Detection-(Cordova)-V2.0.6.zip)
1. Sync native SDK.

#### v2.0.5 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/2.0.5/iOS-Liveness-Detection-(Cordova)-V2.0.5.zip)
1. Sync native SDK.

#### v2.0.4 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/2.0.4/iOS-Liveness-Detection-(Cordova)-V2.0.4.zip)
1. Sync native SDK.
2. Add methods `setPlayPromptAudio` and `setShowAnimationImgs`.

#### v2.0.3 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/2.0.3/iOS-Liveness-Detection-(Cordova)-V2.0.3.zip)
1. Sync native SDK.

#### v2.0.2 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/2.0.2/iOS-Liveness-Detection-(Cordova)-V2.0.2.zip)
1. Sync native SDK.
2. Add methods `setDetectionLevel`, `setRoundBoderColor`, `setEllipseLineColor`.

#### v1.3.4 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.3.4/iOS-Liveness-Detection-(Cordova)-V1.3.4.zip)
1. Sync native SDK.

#### v1.3.3 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.3.3/iOS-Liveness-Detection-(Cordova)-V1.3.3.zip)
1. Optimizing the capture of face image.
2. Support closed eye detection.
3. Add localized string "pls_open_eye".
4. Fix EXC_BAD_ACCESS bug that could occur in some cases.
5. Fix the global service bug.
6. Compressed images of AAIImgs.bundle.

#### v1.2.9 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.2.9/iOS-Liveness-Detection-(Cordova)-V1.2.9.zip)
1. Add methods `setActionTimeoutInterval`, `setPrepareTimeoutInterval`, `setLanguage`.
2. Update Resource.

#### v1.2.8 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.2.8/iOS-Liveness-Detection-(Cordova)-V1.2.8.zip)
1. Upgrade network module.
2. Set the SDK view to be displayed in full screen.

#### v1.2.7 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.2.7/iOS-Liveness-Detection-(Cordova)-V1.2.7.zip)
1. Updated license check feature.

#### v1.2.6 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.2.6/iOS-Liveness-Detection-(Cordova)-V1.2.6.zip)
1. Set the width of the image output by the SDK from 300 to 600.

#### v1.2.5 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.2.5/iOS-Liveness-Detection-(Cordova)-V1.2.5.zip)
1. Refacored AAILivenessViewController.
2. Fix EXC_BAD_ACCESS bug that could occur in some cases.
3. Add other market enum values.

#### v1.2.1 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.2.1/iOS-Liveness-Detection-(Cordova)-V1.2.1.zip)
1. Fix the bug that img of AAILivenessResult may be nil when the onDetectionComplete: method is called.

#### v1.2.0 [Download](https://prod-guardian-cv.oss-ap-southeast-5.aliyuncs.com/sdk/iOS-liveness-detection/1.2.0/iOS-Liveness-Detection-(Cordova)-V1.2.0.zip)
1. Support to initialize SDK with license.
2. Support face occlusion detection(only in the preparation phase, not in the action detection phase), this feature is off by default, you can turn it on if needed.
3. Support Mexico,Malaysia,Pakistan,Nigeria,Colombia.
4. Added the `AAIModel.bundle` resource.