//
//  aainetwork.hpp
//  AAINetwork
//
//  Created by advance on 2022/8/11.
//

#ifndef aainetwork_hpp
#define aainetwork_hpp

#include<string>
#include <map>

#define AAINETWORK_LIB_CLASS_UNAVAILABLE __attribute__((visibility("default"), unavailable("This class is unavailable. Please use the older AAINetwork framework version 1.0.*")))

namespace aai
{
    namespace network
    {
        class AAINETWORK_LIB_CLASS_UNAVAILABLE Request
        {
        public:
            enum ResponseCheck {
                HttpCode200, Json,
            };
            
            Request();
            ~Request();
            Request(const Request &obj);
            
            void setHTTPMethod(const std::string &method);
            void setContentType(const std::string &contentType);
            void setRequestUrl(const std::string &url);
            void setHTTPHeader(const std::string name, const std::string value);
            void setHTTPBody(const std::string &body);
            void setTimeoutInterval(int timeoutIntervalInseconds);
            void setTag(const std::string tag);
            void setResponseCheck(ResponseCheck rc);
            void setCertPining(const std::string pinnedPublicKey);
            
            class Impl;
            Impl* getImpl() const;
        private:
            std::unique_ptr<Impl> pImpl;
        };

        class AAINETWORK_LIB_CLASS_UNAVAILABLE Response
        {
        public:
            Response();
            ~Response();
            
            std::map<std::string, std::string> headers;
            std::string responseBody;
            bool isResponseValid;
        };

        class AAINETWORK_LIB_CLASS_UNAVAILABLE HTTPSession
        {
        public:
            HTTPSession();
            ~HTTPSession();

            static HTTPSession& defaultSession();
            Response sendRequest(const Request &request);

        private:
            class Impl;
            std::unique_ptr<Impl> pImpl;
        };
        
        
        __attribute__((visibility("default")))
        void aes(const std::string &key, uint8_t *data, size_t len);
        
        __attribute__((visibility("default")))
        std::string base64Encode(const std::string &s);
        
        __attribute__((visibility("default")))
        void base64Decode(const std::string &s, std::string &ret);
        
        __attribute__((visibility("default")))
        static const std::string moduleVersion = "1.1.0";
    };
};


#endif /* aainetwork_hpp */
