//
//  AAICustomScanController4.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2023/7/31.
//

import UIKit

import AAIGlobalIQAUI

class CustomNavBar4: UIView {
    var closeBtn: UIButton?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        let contentView = UIView()
        contentView.translatesAutoresizingMaskIntoConstraints = false
        self.addSubview(contentView)
        
        let closeBtn = UIButton(type: .custom)
        let closeImg = UIImage(named: "c4_close")
        closeBtn.setImage(closeImg, for: .normal)
        closeBtn.translatesAutoresizingMaskIntoConstraints = false
        contentView.addSubview(closeBtn)
        self.closeBtn = closeBtn
        
        let titleLabel = UILabel()
        titleLabel.text = "Verify Identity"
        titleLabel.font = UIFont.boldSystemFont(ofSize: 18)
        titleLabel.translatesAutoresizingMaskIntoConstraints = false
        contentView.addSubview(titleLabel)
        
        let line = UIImageView()
        line.image = UIImage(named: "c4_nav_line")
        line.translatesAutoresizingMaskIntoConstraints = false
        contentView.addSubview(line)
        
        let cons: [NSLayoutConstraint] = [
            closeBtn.widthAnchor.constraint(equalToConstant: 28),
            closeBtn.heightAnchor.constraint(equalToConstant: 28),
            closeBtn.rightAnchor.constraint(equalTo: contentView.rightAnchor, constant: -21),
            closeBtn.centerYAnchor.constraint(equalTo: contentView.centerYAnchor),
            
            titleLabel.rightAnchor.constraint(lessThanOrEqualTo: closeBtn.leftAnchor, constant: 21),
            titleLabel.centerXAnchor.constraint(equalTo: contentView.centerXAnchor),
            titleLabel.centerYAnchor.constraint(equalTo: contentView.centerYAnchor),
            
            line.leftAnchor.constraint(equalTo: contentView.leftAnchor),
            line.rightAnchor.constraint(equalTo: contentView.rightAnchor),
            line.heightAnchor.constraint(equalToConstant: 4),
            line.bottomAnchor.constraint(equalTo: contentView.bottomAnchor),
            
            AAIIQACommUtil.topContraint(of: contentView, toSV: self, constant: 0),
            AAIIQACommUtil.leftContraint(of: contentView, toSV: self, constant: 0),
            AAIIQACommUtil.rightContraint(of: contentView, toSV: self, constant: 0),
            contentView.heightAnchor.constraint(equalToConstant: 44),
            self.bottomAnchor.constraint(equalTo: contentView.bottomAnchor)
        ]
        NSLayoutConstraint.activate(cons)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

class AAICustomScanController4: AAIIQAScanController {
    private var _topLabel: UILabel?
    private var _tipLabel: UILabel?
    private var _timerLabel: UILabel?
    
    private var _flashOff: Bool = true
    private var _flashBtn: UIButton?
    private var _flashBtnCenterXCons: NSLayoutConstraint?
    private var _flashBtnRightCons: NSLayoutConstraint?
    
    private var _takePhotoBtn: UIButton?
    
    private var _loadingView: UIView?
    
    override func loadCameraViewPortCons(_ cameraView: UIView) -> NSLayoutConstraint? {
        // Update cameraView top constraint
        if let topLabel = _topLabel {
            return cameraView.topAnchor.constraint(equalTo: topLabel.bottomAnchor, constant: 24)
        }
        return nil
    }
    
    override func loadSDKUI() {
        guard let sv = self.view else {
            return
        }
        
        // Add your custom navBar.
        let navbar = CustomNavBar4()
        navbar.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(navbar)
        navbar.closeBtn?.addTarget(self, action: #selector(tapCloseBtn), for: .touchUpInside)
        
        let navCons: [NSLayoutConstraint] = [
            navbar.topAnchor.constraint(equalTo: sv.topAnchor),
            navbar.leftAnchor.constraint(equalTo: sv.leftAnchor),
            navbar.rightAnchor.constraint(equalTo: sv.rightAnchor),
        ]
        NSLayoutConstraint.activate(navCons)
        
        // Add top label
        let titleLabel = UILabel()
        titleLabel.font = AAIIQACommUtil.font(withSize: 20, isBold: true)
        titleLabel.text = "Scan Front Side of ID"
        titleLabel.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(titleLabel)
        
        let descLabel = UILabel()
        descLabel.font = AAIIQACommUtil.font(withSize: 14, isBold: false)
        descLabel.text = "Position the front of ID in the center with the edges aligned."
        descLabel.translatesAutoresizingMaskIntoConstraints = false
        descLabel.textAlignment = .center
        descLabel.numberOfLines = 0
        sv.addSubview(descLabel)
        _topLabel = descLabel
        
        var marginLeft: CGFloat = 20
        if let marginLR = AAIGlobalIQASDK.sdkConfig().uiConfig.cameraViewMarginLRInPortraitMode {
            marginLeft = CGFloat(marginLR.floatValue)
        }
        
        let topLabelCons: [NSLayoutConstraint] = [
            titleLabel.topAnchor.constraint(equalTo: navbar.bottomAnchor, constant: 22),
            titleLabel.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
            descLabel.topAnchor.constraint(equalTo: titleLabel.bottomAnchor, constant: 8),
            descLabel.leftAnchor.constraint(equalTo: sv.leftAnchor, constant: marginLeft),
            descLabel.rightAnchor.constraint(equalTo: sv.rightAnchor, constant: -marginLeft)
        ]
        NSLayoutConstraint.activate(topLabelCons)
        
        // Add cameraView
        self.loadCameraView()
        
        guard let cameraView = self.cameraView else {
            return
        }
        // Add tip label
        let timerLabel = UILabel()
        timerLabel.font = AAIIQACommUtil.font(withSize: 14, isBold: false)
        timerLabel.textAlignment = .center
        timerLabel.textColor = AAIIQACommUtil.color(withHexRGB: 0xED816E, alpha: 1)
        timerLabel.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(timerLabel)
        _timerLabel = timerLabel
        
        let opMode = AAIGlobalIQASDK.sdkConfig().operatingMode
        if opMode == .default || opMode == .scanning {
            let tipLabel = UILabel()
            tipLabel.font = AAIIQACommUtil.font(withSize: 14, isBold: false)
            tipLabel.textAlignment = .center
            tipLabel.translatesAutoresizingMaskIntoConstraints = false
            sv.addSubview(tipLabel)
            _tipLabel = tipLabel
        }
        
        // Add flashBtn
        let flashBtn = UIButton(type: .custom)
        flashBtn.setImage(UIImage(named: "c4_flash_off"), for: .normal)
        flashBtn.setImage(UIImage(named: "c4_flash"), for: .selected)
        
        flashBtn.setTitleColor(.black, for: .normal)
        flashBtn.translatesAutoresizingMaskIntoConstraints = false
        flashBtn.layer.borderWidth = 1
        flashBtn.layer.borderColor = UIColor.black.cgColor
        sv.addSubview(flashBtn)
        flashBtn.addTarget(self, action: #selector(tapFlashBtnAction(_:)), for: .touchUpInside)
        _flashBtn = flashBtn
        
        // Add bottom encryption description
        let encryDescImgView = UIImageView(image: UIImage(named: "c4_encr_desc"))
        encryDescImgView.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(encryDescImgView)
        
        let flashBtnCenterXCons = flashBtn.centerXAnchor.constraint(equalTo: sv.centerXAnchor)
        _flashBtnCenterXCons = flashBtnCenterXCons
        
        if opMode == .default || opMode == .scanning {
            let bottomCons: [NSLayoutConstraint] = [
                timerLabel.topAnchor.constraint(equalTo: cameraView.bottomAnchor, constant: 8),
                timerLabel.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
                
                flashBtn.widthAnchor.constraint(equalToConstant: 44),
                flashBtn.heightAnchor.constraint(equalToConstant: 44),
                flashBtnCenterXCons,
                flashBtn.topAnchor.constraint(equalTo: timerLabel.bottomAnchor, constant: 24),
                
                _tipLabel!.topAnchor.constraint(equalTo: flashBtn.bottomAnchor, constant: 40),
                _tipLabel!.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
                
                encryDescImgView.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
                AAIIQACommUtil.bottomContraint(of: encryDescImgView, toSV: sv, constant: -20)
            ]
            NSLayoutConstraint.activate(bottomCons)
        } else {
            // Only in Photo Mode
            self.addTakePhotoBtn(sv)
            
            let bottomCons: [NSLayoutConstraint] = [
                timerLabel.topAnchor.constraint(equalTo: cameraView.bottomAnchor, constant: 8),
                timerLabel.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
                
                flashBtn.widthAnchor.constraint(equalToConstant: 44),
                flashBtn.heightAnchor.constraint(equalToConstant: 44),
                flashBtn.rightAnchor.constraint(equalTo: _takePhotoBtn!.leftAnchor, constant: -24),
                flashBtn.topAnchor.constraint(equalTo: timerLabel.bottomAnchor, constant: 24),
                
                encryDescImgView.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
                AAIIQACommUtil.bottomContraint(of: encryDescImgView, toSV: sv, constant: -20)
            ]
            NSLayoutConstraint.activate(bottomCons)
        }
        
        guard let mainView = self.view as? AAIIQAScanMainView else {
            return
        }
        mainView.detectionDelegate = self
    }
    
    private func addTakePhotoBtn(_ contentView: UIView) {
        // Add takephoto btn
        let takePhotoBtn = UIButton(type: .custom)
        let takePhotoImg = UIImage(named: "c4_take_photo")
        takePhotoBtn.setImage(takePhotoImg, for: .normal)
        takePhotoBtn.translatesAutoresizingMaskIntoConstraints = false
        contentView.addSubview(takePhotoBtn)
        _takePhotoBtn = takePhotoBtn
        
        _flashBtnCenterXCons?.isActive = false
        let cons: [NSLayoutConstraint] = [
            takePhotoBtn.widthAnchor.constraint(equalToConstant: takePhotoImg!.size.width),
            takePhotoBtn.heightAnchor.constraint(equalToConstant: takePhotoImg!.size.height),
            takePhotoBtn.centerXAnchor.constraint(equalTo: contentView.centerXAnchor),
            takePhotoBtn.topAnchor.constraint(equalTo: cameraView!.bottomAnchor, constant: 32),
            _flashBtn!.rightAnchor.constraint(equalTo: takePhotoBtn.leftAnchor, constant: -24)
        ]
        NSLayoutConstraint.activate(cons)
        takePhotoBtn.addTarget(self, action: #selector(tapTakePhotoBtnAction), for: .touchUpInside)
    }
    
    @objc func tapCloseBtn() {
        self.closePage(true)
    }
    
    @objc func tapFlashBtnAction(_ flashBtn: UIButton) {
        if (_flashOff) {
            // turn flash on
            _flashOff = false
            flashBtn.isSelected = true
            self.flashOff = false
        } else {
            // turn flash off
            _flashOff = true
            flashBtn.isSelected = false
            self.flashOff = true
        }
    }
    
    override func beginRequest(_ currVC: UIViewController?) {
        guard let sv = currVC?.view else {
            return
        }
        
        let loadingView = AAICustomLoadingView4()
        loadingView.translatesAutoresizingMaskIntoConstraints = false
        sv.addSubview(loadingView)
        let cons: [NSLayoutConstraint] = [
            loadingView.centerXAnchor.constraint(equalTo: sv.centerXAnchor),
            loadingView.centerYAnchor.constraint(equalTo: sv.centerYAnchor),
        ]
        NSLayoutConstraint.activate(cons)
        
        _loadingView = loadingView
    }
    
    override func endRequest(_ currVC: UIViewController?) {
        _loadingView?.removeFromSuperview()
    }
}

extension AAICustomScanController4: AAIIQADetectionDelegate {
    func iqaOnDetectionStart() {
        _timerLabel?.text = "Please scan the document in \(AAIGlobalIQASDK.sdkConfig().detectionTimeoutInterval)"
    }
    
    func iqa(onDetectionWarn warnCode: AAIIQAWarnCode) {
        var stateKey: String?
        switch warnCode {
        case .noCard:
            stateKey = "no_card"
        case .tooSmallCard:
            stateKey = "too_small_card"
        case .edgeCross:
            stateKey = "iqa_min_gap_ratio"
        case .cardPoorQuality:
            stateKey = "iqa_card_poor_quality"
        case .good:
            stateKey = "hold_phone"
        case .hasOccluded:
            stateKey = "card_has_occluded"
        case .unspecified:
            let _ = "";
        @unknown default:
            fatalError("Unknown AAIIQAWarnCode!")
        }
        
        if let stateKey = stateKey {
            _tipLabel?.text = AAIIQACommUtil.localStr(forKey: stateKey)
        } else {
            _tipLabel?.text = nil
        }
    }
    
    func iqa(onDetectionRemainTimeChanged remainTime: Int, totalTime: Int, contentView: UIView) {
        _timerLabel?.text = "Please scan the document in \(remainTime)"
    }
    
    func iqa(onDetectionTimeout contentView: UIView, consumeTimes: Int, remainingRetryTimes: Int, completionHandler: @escaping (AAIIQADetectionTimeoutDisposition) -> Void) {
        print("onDetectionTimeout, consumeTimes: \(consumeTimes), remainingRetryTimes: \(remainingRetryTimes)");
        if (remainingRetryTimes == 0) {
            _timerLabel?.isHidden = true
            _tipLabel?.isHidden = true

            // Add takephoto button
            self.addTakePhotoBtn(contentView)
            completionHandler(.usePhotoMode)
        } else {
            completionHandler(.retry)
        }
    }
    
    /*
    func iqa(onDetectionSuccess contextInfo: [AnyHashable : Any]?, contentView: UIView, completionHandler: @escaping (AAIIQADetectionSuccessDisposition) -> Void) {
        
        //
        print("onDetectionSuccess !")
        completionHandler(.default)
    }
    */
    
    @objc func tapTakePhotoBtnAction() {
        if let takePhotoMainView = self.view as? AAIIQATakePhotoMainView {
            takePhotoMainView.tapTakePhotoBtnAction()
        }
    }
}
