//
//  AAICustomScanController1.swift
//  AAIGlobalIQASDKSwiftDemo
//
//  Created by advance on 2022/9/30.
//

import UIKit
import AAIGlobalIQAUI

class AAICustomScanController2: AAIIQAScanController {
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Add custom topDescView
        let assistView = UIView()
        assistView.translatesAutoresizingMaskIntoConstraints = false
        self.view .addSubview(assistView)
        
        // You can ajust the attribute string to meet your needs
        let boldStr = "the front side your KTP"
        let descStr = "Position the \(boldStr) in the center with the edges aligned."
        let boldStrRange = NSString(string: descStr).range(of: boldStr)
        
        // You can ajust the textColor and font to meet your needs
        let paragraphStyle: NSMutableParagraphStyle = NSMutableParagraphStyle()
        paragraphStyle.alignment = .center
        
        let customFont = AAIIQACommUtil.font(withSize: 15, isBold: false)
        let textColor: UIColor = .black
        let attrStr = NSMutableAttributedString(string: descStr, attributes: [.font: customFont, .foregroundColor: textColor, .paragraphStyle: paragraphStyle])
        attrStr.setAttributes([.font: UIFont.boldSystemFont(ofSize: 15), .foregroundColor: textColor], range: boldStrRange)
        
        let descLabel = UILabel()
        descLabel.attributedText = attrStr
        descLabel.numberOfLines = 0
        descLabel.translatesAutoresizingMaskIntoConstraints = false
        self.view.addSubview(descLabel)
        
        guard let cameraView = self.cameraView, let navBarView = self.navBarView else {
            return
        }
        
        let bottomCons = assistView.bottomAnchor.constraint(equalTo: cameraView.topAnchor)
        bottomCons.priority = .defaultLow
        let constrs: [NSLayoutConstraint] = [
            assistView.topAnchor.constraint(equalTo: navBarView.bottomAnchor),
            assistView.leftAnchor.constraint(equalTo: cameraView.leftAnchor),
            assistView.rightAnchor.constraint(equalTo: cameraView.rightAnchor),
            bottomCons,
            
            descLabel.leftAnchor.constraint(equalTo: assistView.leftAnchor),
            descLabel.rightAnchor.constraint(equalTo: assistView.rightAnchor),
            descLabel.centerYAnchor.constraint(equalTo: assistView.centerYAnchor)
        ]
        NSLayoutConstraint.activate(constrs)
        
    }
}
