//
//  AAIIQATipView.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/14.
//

#import "AAIIQATipView.h"
#import "AAIIQACommUtil.h"
#import "AAIGlobalIQAInternalConfig.h"

#pragma mark - portrait

@interface AAIIQAPorTipView : UIView<AAIIQADetectionDelegate>

@property(nonatomic) UIImageView *iconImgView;
@property(nonatomic) UILabel *textLabel;

@end
@implementation AAIIQAPorTipView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self createSubviews];
    }
    return self;
}

- (void)createSubviews
{
    UIView *contentView = [self createContentView];
    [self addSubview:contentView];
    NSArray *allCons = @[
        [contentView.leftAnchor constraintEqualToAnchor:self.leftAnchor],
        [contentView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
        [contentView.centerYAnchor constraintEqualToAnchor:self.centerYAnchor constant:0],
    ];
    NSLayoutConstraint *w = allCons.lastObject;
    w.priority = UILayoutPriorityDefaultLow;
    
    [NSLayoutConstraint activateConstraints:allCons];
}

- (UIView *)createContentView
{
    AAIGlobalIQAUIConfig *uiConfig = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig;
    UIView *contentView = [[UIView alloc] init];
    contentView.translatesAutoresizingMaskIntoConstraints = NO;
    
    UIImageView *imgView = [[UIImageView alloc] init];
    imgView.translatesAutoresizingMaskIntoConstraints = NO;
    [contentView addSubview:imgView];
    imgView.hidden = !(uiConfig.tipIconVisible);
    
    UILabel *label = [[UILabel alloc] init];
    label.font = [AAIIQACommUtil fontWithSize:14 isBold:NO];
    label.textColor = uiConfig.primaryTextColor;
    label.numberOfLines = 0;
    label.textAlignment = NSTextAlignmentCenter;
    label.translatesAutoresizingMaskIntoConstraints = NO;
    [contentView addSubview:label];
    
    NSArray *allCons = @[
        [imgView.topAnchor constraintEqualToAnchor:contentView.topAnchor],
        [imgView.widthAnchor constraintEqualToConstant:50],
        [imgView.heightAnchor constraintEqualToConstant:50],
        [imgView.centerXAnchor constraintEqualToAnchor:contentView.centerXAnchor],
        
        [label.topAnchor constraintEqualToAnchor:imgView.bottomAnchor constant:14],
        
        [imgView.leftAnchor constraintGreaterThanOrEqualToAnchor:contentView.leftAnchor constant:0],
        [imgView.rightAnchor constraintLessThanOrEqualToAnchor:contentView.rightAnchor constant:0],
        
        [label.leftAnchor constraintEqualToAnchor:contentView.leftAnchor constant:20],
        [label.rightAnchor constraintEqualToAnchor:contentView.rightAnchor constant:-20],
        [contentView.bottomAnchor constraintEqualToAnchor:label.bottomAnchor constant:0]
    ];
    
    [NSLayoutConstraint activateConstraints:allCons];
    
    _iconImgView = imgView;
    _textLabel = label;
    
    return contentView;
}

#pragma mark AAIIQADetectionDelegate

- (void)iqaOnDetectionWarn:(AAIIQAWarnCode)warnCode
{
    NSString *stateKey = nil;
    NSString *iconImgName = nil;
    switch (warnCode) {
        case AAIIQAWarnCodeNoCard:
            stateKey = @"no_card";
            iconImgName = @"iqa_scan_warning";
            break;
        case AAIIQAWarnCodeCardPoorQuality:
            stateKey = @"iqa_card_poor_quality";
            iconImgName = @"iqa_scan_warning";
            break;
        case AAIIQAWarnCodeTooSmallCard:
            stateKey = @"too_small_card";
            iconImgName = @"iqa_scan_warning";
            break;
        case AAIIQAWarnCodeEdgeCross:
            stateKey = @"iqa_min_gap_ratio";
            iconImgName = @"iqa_scan_warning";
            break;
        case AAIIQAWarnCodeCardGlossy:
            stateKey = @"iqa_card_too_glossy";
            iconImgName = @"iqa_scan_warning";
            break;
        case AAIIQAWarnCodeGood:
            stateKey = @"hold_phone";
            iconImgName = @"iqa_scan_processing";
            break;
        case AAIIQAWarnCodeHasOccluded:
            stateKey = @"card_has_occluded";
            iconImgName = @"iqa_scan_warning";
            break;

        default:
            break;
    }
    
    if (iconImgName) {
        _iconImgView.image = [AAIIQACommUtil imgWithName:iconImgName];
    } else {
        _iconImgView.image = nil;
    }
    
    if (stateKey) {
        _textLabel.text = [AAIIQACommUtil localStrForKey:stateKey];
    } else {
        _textLabel.text = nil;
    }
}

- (void)iqaOnDetectionSucceed:(UIImage *)rawImage
{
    _iconImgView.image = [AAIIQACommUtil imgWithName:@"iqa_scan_successfully"];
    _textLabel.text = [AAIIQACommUtil localStrForKey:@"iqa_scan_successfully"];
}

@end

#pragma mark - landscape

@interface AAIIQALanTipView : UIView<AAIIQADetectionDelegate>
{
    UILabel *_label;
}
@end
@implementation AAIIQALanTipView
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.layer.cornerRadius = 2;
        [self createSubviews];
    }
    return self;
}

- (void)createSubviews
{
    UILabel *label = [[UILabel alloc] init];
    label.font = [AAIIQACommUtil fontWithSize:14 isBold:NO];
    label.textColor = [UIColor whiteColor];
    label.numberOfLines = 0;
    label.textAlignment = NSTextAlignmentCenter;
    label.translatesAutoresizingMaskIntoConstraints = NO;
    [self addSubview:label];
    _label = label;
    
    NSArray *allCons = @[
        [label.topAnchor constraintEqualToAnchor:self.topAnchor constant:5],
        [label.leftAnchor constraintEqualToAnchor:self.leftAnchor constant:13],
        [label.rightAnchor constraintEqualToAnchor:self.rightAnchor constant:-13],
        [label.bottomAnchor constraintEqualToAnchor:self.bottomAnchor constant:-5],
    ];
    [NSLayoutConstraint activateConstraints:allCons];
}

#pragma mark AAIIQADetectionDelegate

- (void)iqaOnDetectionWarn:(AAIIQAWarnCode)warnCode
{
    NSString *stateKey = nil;
    switch (warnCode) {
        case AAIIQAWarnCodeNoCard:
            stateKey = @"no_card";
            self.backgroundColor = [AAIIQACommUtil colorWithHexRGB:0xDE1C11 alpha:0.6];
            break;
        case AAIIQAWarnCodeCardPoorQuality:
            stateKey = @"iqa_card_poor_quality";
            self.backgroundColor = [AAIIQACommUtil colorWithHexRGB:0xDE1C11 alpha:0.6];
            break;
        case AAIIQAWarnCodeTooSmallCard:
            stateKey = @"too_small_card";
            self.backgroundColor = [AAIIQACommUtil colorWithHexRGB:0xDE1C11 alpha:0.6];
            break;
        case AAIIQAWarnCodeEdgeCross:
            stateKey = @"iqa_min_gap_ratio";
            self.backgroundColor = [AAIIQACommUtil colorWithHexRGB:0xDE1C11 alpha:0.6];
            break;
        case AAIIQAWarnCodeGood:
            stateKey = @"hold_phone";
            self.backgroundColor = [AAIIQACommUtil colorWithHexRGB:0x008814 alpha:0.6];
            break;
        case AAIIQAWarnCodeHasOccluded:
            stateKey = @"card_has_occluded";
            self.backgroundColor = [AAIIQACommUtil colorWithHexRGB:0xDE1C11 alpha:0.6];
            break;
        default:
            break;
    }
    
    if (stateKey) {
        _label.text = [AAIIQACommUtil localStrForKey:stateKey];
    } else {
        _label.text = nil;
    }
    
}

- (void)iqaOnDetectionSucceed:(UIImage *)rawImage
{
    _label.text = [AAIIQACommUtil localStrForKey:@"iqa_scan_successfully"];
}

@end


@interface AAIIQATipView()
{
    UIView<AAIIQADetectionDelegate> *_porTipView;
    UIView<AAIIQADetectionDelegate> *_lanTipView;
    BOOL _portrait;
    
    NSArray *_porCons;
    NSArray *_lanCons;
    
    AAIIQAWarnCode _currWarnCode;
}
@end

@implementation AAIIQATipView
@synthesize portrait = _portrait;

+ (AAIIQATipView *)tipWithIfPortrait:(BOOL)isPortrait
{
    return [[AAIIQATipView alloc] initWithIfPortrait:isPortrait];
}

- (instancetype)initWithIfPortrait:(BOOL)isPortrait
{
    self = [super initWithFrame:CGRectZero];
    if (self) {
        _currWarnCode = AAIIQAWarnCodeUnspecified;
        self.portrait = isPortrait;
    }
    return self;
}

- (void)setPortrait:(BOOL)portrait
{
    _portrait = portrait;
    
    if (portrait) {
        // Remove _lanTipView
        if (_lanTipView != nil && [_lanTipView superview] != nil) {
            [NSLayoutConstraint deactivateConstraints:_lanCons];
            [_lanTipView removeFromSuperview];
        }
        
        // Add _porTipView
        if (_porTipView == nil) {
            id<AAIIQATipViewDataSource> porTipViewDS = [AAIGlobalIQAInternalConfig shareConfig].originConfig.tipViewDataSource;
            if (porTipViewDS) {
                // Custom portrait tip view
                if ([porTipViewDS respondsToSelector:@selector(iqaCreateTipView:)]) {
                    _porTipView = [porTipViewDS iqaCreateTipView:YES];
                }
            }
            if (!_porTipView) {
                _porTipView = [[AAIIQAPorTipView alloc] init];
            }
            _porTipView.translatesAutoresizingMaskIntoConstraints = NO;
        }
        
        if (_porTipView.superview == nil) {
            [self addSubview:_porTipView];
        }
        
        if (_porCons == nil) {
            _porCons = @[
                [_porTipView.topAnchor constraintEqualToAnchor:self.topAnchor],
                [_porTipView.leftAnchor constraintEqualToAnchor:self.leftAnchor],
                [_porTipView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
                [_porTipView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor],
            ];
        }
        
        [NSLayoutConstraint activateConstraints:_porCons];
        
        // Update UI
        if (_currWarnCode != AAIIQAWarnCodeUnspecified) {
            if ([_porTipView respondsToSelector:@selector(iqaOnDetectionWarn:)]) {
                [_porTipView iqaOnDetectionWarn:_currWarnCode];
            }
        }
    } else {
        // Remove _porTipView
        if (_porTipView != nil && [_porTipView superview] != nil) {
            [NSLayoutConstraint deactivateConstraints:_porCons];
            [_porTipView removeFromSuperview];
        }
        
        if (_lanTipView == nil) {
            id<AAIIQATipViewDataSource> lanTipViewDS = [AAIGlobalIQAInternalConfig shareConfig].originConfig.tipViewDataSource;
            if (lanTipViewDS) {
                // Custom portrait tip view
                if ([lanTipViewDS respondsToSelector:@selector(iqaCreateTipView:)]) {
                    _lanTipView = [lanTipViewDS iqaCreateTipView:NO];
                }
            }
            if (!_lanTipView) {
                _lanTipView = [[AAIIQALanTipView alloc] init];
            }
            _lanTipView.translatesAutoresizingMaskIntoConstraints = NO;
        }
        
        if (_lanTipView.superview == nil) {
            [self addSubview:_lanTipView];
        }
        
        if (_lanCons == nil) {
            _lanCons = @[
                [_lanTipView.topAnchor constraintEqualToAnchor:self.topAnchor],
                [_lanTipView.leftAnchor constraintEqualToAnchor:self.leftAnchor],
                [_lanTipView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
                [_lanTipView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor],
            ];
        }
        
        [NSLayoutConstraint activateConstraints:_lanCons];
        
        if (_currWarnCode != AAIIQAWarnCodeUnspecified) {
            if ([_lanTipView respondsToSelector:@selector(iqaOnDetectionWarn:)]) {
                [_lanTipView iqaOnDetectionWarn:_currWarnCode];
            }
        }
        
    }
}

- (BOOL)isPortrait
{
    return _portrait;
}

#pragma mark AAIIQADetectionDelegate

- (void)iqaOnDetectionWarn:(AAIIQAWarnCode)warnCode
{
    _currWarnCode = warnCode;
    
    if (_portrait) {
        if ([_porTipView respondsToSelector:@selector(iqaOnDetectionWarn:)]) {
            [_porTipView iqaOnDetectionWarn:warnCode];
        }
    } else {
        if ([_lanTipView respondsToSelector:@selector(iqaOnDetectionWarn:)]) {
            [_lanTipView iqaOnDetectionWarn:warnCode];
        }
    }
}

- (void)iqaOnDetectionRemainTimeChanged:(NSInteger)remainTime totalTime:(NSInteger)totalTime contentView:(UIView *)contentView
{
    if (_portrait) {
        if ([_porTipView respondsToSelector:@selector(iqaOnDetectionRemainTimeChanged:totalTime:contentView:)]) {
            [_porTipView iqaOnDetectionRemainTimeChanged:remainTime totalTime:totalTime contentView:contentView];
        }
    } else {
        if ([_lanTipView respondsToSelector:@selector(iqaOnDetectionRemainTimeChanged:totalTime:contentView:)]) {
            [_lanTipView iqaOnDetectionRemainTimeChanged:remainTime totalTime:totalTime contentView:contentView];
        }
    }
}

- (void)iqaOnDetectionSucceed:(UIImage *)rawImage
{
    _currWarnCode = AAIIQAWarnCodeUnspecified;
    
    if (_portrait) {
        if ([_porTipView respondsToSelector:@selector(iqaOnDetectionSucceed:)]) {
            [_porTipView iqaOnDetectionSucceed:nil];
        }
    } else {
        if ([_lanTipView respondsToSelector:@selector(iqaOnDetectionSucceed:)]) {
            [_lanTipView iqaOnDetectionSucceed:nil];
        }
    }
}

@end
