//
//  AAIIQATakePhotoTipView.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/23.
//

#import "AAIIQATakePhotoTipView.h"
#import "AAIIQACommUtil.h"
#import "AAIGlobalIQAInternalConfig.h"

@interface AAIIQATakePhotoPorTipView : UIView
@end
@implementation AAIIQATakePhotoPorTipView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        AAIGlobalIQAUIConfig *uiConfig = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig;
        self.backgroundColor = uiConfig.takePhotoTipBackgroundColor;
        
        NSLayoutXAxisAnchor *leftAnchor = nil;
        NSArray *imgConstr = nil;
        if (uiConfig.takePhotoTipLeftIconVisible) {
            UIImageView *imgView = [[UIImageView alloc] init];
            imgView.image = [AAIIQACommUtil imgWithName:@"iqa_take_photo_tip"];
            imgView.translatesAutoresizingMaskIntoConstraints = NO;
            [self addSubview:imgView];
            
            imgConstr = @[
                [imgView.centerYAnchor constraintEqualToAnchor:self.centerYAnchor],
                [imgView.leftAnchor constraintEqualToAnchor:self.leftAnchor constant:11],
                [imgView.widthAnchor constraintEqualToConstant:30],
                [imgView.heightAnchor constraintEqualToConstant:30]
            ];
            leftAnchor = imgView.rightAnchor;
        } else {
            leftAnchor = self.leftAnchor;
        }
        
        UILabel *titleLabel = [[UILabel alloc] init];
        titleLabel.numberOfLines = 0;
        
        if (!uiConfig.takePhotoTipAttrText) {
            titleLabel.font = [AAIIQACommUtil fontWithSize:14 isBold:YES];
            titleLabel.textColor = uiConfig.takePhotoTipTextColor;
            titleLabel.text = [AAIIQACommUtil localStrForKey:@"iqa_take_photo_tips"];
        } else {
            titleLabel.attributedText = uiConfig.takePhotoTipAttrText;
        }
        
        titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:titleLabel];
        
        NSArray *labelConstr = @[
            [titleLabel.topAnchor constraintEqualToAnchor:self.topAnchor constant:11],
            [titleLabel.leftAnchor constraintEqualToAnchor:leftAnchor constant:11],
            [titleLabel.bottomAnchor constraintEqualToAnchor:self.bottomAnchor constant:-11],
            [titleLabel.rightAnchor constraintEqualToAnchor:self.rightAnchor constant:-11],
        ];
        
        NSMutableArray *constr = [[NSMutableArray alloc] init];
        if (imgConstr) {
            [constr addObjectsFromArray:imgConstr];
        }
        [constr addObjectsFromArray:labelConstr];
        
        [NSLayoutConstraint activateConstraints:constr];
    }
    return self;
}

@end


@interface AAIIQATakePhotoLanTipView : UIView
@end
@implementation AAIIQATakePhotoLanTipView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        AAIGlobalIQAUIConfig *uiConfig = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig;
        self.backgroundColor = uiConfig.takePhotoTipBackgroundColor;
        
        UIView *hv = [[UIView alloc] init];
        hv.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:hv];
        
        NSLayoutXAxisAnchor *leftAnchor = nil;
        NSArray<NSLayoutConstraint *> *iconLabelCons = nil;
        if (uiConfig.takePhotoTipLeftIconVisible) {
            UILabel *iconLabel = [[UILabel alloc] init];
            iconLabel.backgroundColor = [AAIIQACommUtil colorWithHexRGB:0x30B043 alpha:1];
            iconLabel.text = @"!";
            iconLabel.textColor = [UIColor whiteColor];
            iconLabel.textAlignment = NSTextAlignmentCenter;
            iconLabel.translatesAutoresizingMaskIntoConstraints = NO;
            iconLabel.layer.cornerRadius = 7;
            iconLabel.layer.masksToBounds = YES;
            iconLabel.font = [AAIIQACommUtil fontWithSize:13 isBold:NO];
            [hv addSubview:iconLabel];
            
            iconLabelCons = @[
                [iconLabel.leftAnchor constraintEqualToAnchor:hv.leftAnchor],
                [iconLabel.widthAnchor constraintEqualToConstant:14],
                [iconLabel.heightAnchor constraintEqualToConstant:14],
                [iconLabel.centerYAnchor constraintEqualToAnchor:hv.centerYAnchor],
            ];
            
            leftAnchor = iconLabel.rightAnchor;
        } else {
            leftAnchor = hv.leftAnchor;
        }
        
        UILabel *titleLabel = [[UILabel alloc] init];
        titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        if (!uiConfig.takePhotoTipAttrText) {
            titleLabel.font = [AAIIQACommUtil fontWithSize:14 isBold:NO];
            titleLabel.textColor = uiConfig.takePhotoTipTextColor;
            titleLabel.text = [AAIIQACommUtil localStrForKey:@"iqa_take_photo_tips"];
        } else {
            titleLabel.attributedText = uiConfig.takePhotoTipAttrText;
        }
        
        [hv addSubview:titleLabel];
        
        NSMutableArray<NSLayoutConstraint *> *hvCons = [[NSMutableArray alloc] init];
        
        NSArray<NSLayoutConstraint *> *hvTitleLabelCons = @[
            [titleLabel.leftAnchor constraintEqualToAnchor:leftAnchor constant:9],
            [titleLabel.rightAnchor constraintEqualToAnchor:hv.rightAnchor],
            [titleLabel.topAnchor constraintEqualToAnchor:hv.topAnchor],
            [titleLabel.bottomAnchor constraintEqualToAnchor:hv.bottomAnchor],
        ];
        if (iconLabelCons) {
            [hvCons addObjectsFromArray:iconLabelCons];
        }
        [hvCons addObjectsFromArray:hvTitleLabelCons];
        
        [NSLayoutConstraint activateConstraints:hvCons];
        
        NSArray<NSLayoutConstraint *> *cons = @[
            [hv.leftAnchor constraintEqualToAnchor:self.leftAnchor constant:22],
            [hv.rightAnchor constraintEqualToAnchor:self.rightAnchor constant:-22],
            [hv.topAnchor constraintEqualToAnchor:self.topAnchor constant:5],
            [hv.bottomAnchor constraintEqualToAnchor:self.bottomAnchor constant:-5],
        ];
        [NSLayoutConstraint activateConstraints:cons];
    }
    return self;
}
@end



@interface AAIIQATakePhotoTipView()
{
    UIView *_porTipView;
    UIView *_lanTipView;
    BOOL _portrait;
    
    NSArray *_porCons;
    NSArray *_lanCons;
}
@end
@implementation AAIIQATakePhotoTipView
@synthesize portrait = _portrait;

+ (AAIIQATakePhotoTipView *)tipWithIfPortrait:(BOOL)isPortrait
{
    return [[AAIIQATakePhotoTipView alloc] initWithIfPortrait:isPortrait];
}

- (instancetype)initWithIfPortrait:(BOOL)isPortrait
{
    self = [super initWithFrame:CGRectZero];
    if (self) {
        self.portrait = isPortrait;
        self.layer.cornerRadius = 2;
        self.layer.masksToBounds = YES;
    }
    return self;
}

- (void)setPortrait:(BOOL)portrait
{
    _portrait = portrait;
    
    if (portrait) {
        // Remove _lanTipView
        if (_lanTipView != nil && [_lanTipView superview] != nil) {
            [NSLayoutConstraint deactivateConstraints:_lanCons];
            [_lanTipView removeFromSuperview];
        }
        
        // Add _porTipView
        if (_porTipView == nil) {
            id<AAIIQATakePhotoTipViewDataSource> porTipViewDS = [AAIGlobalIQAInternalConfig shareConfig].originConfig.takePhotoTipViewDataSource;
            if (porTipViewDS) {
                if ([porTipViewDS respondsToSelector:@selector(iqaCreateTakePhotoTipView:)]) {
                    _porTipView = [porTipViewDS iqaCreateTakePhotoTipView:YES];
                }
            }
            if (!_porTipView) {
                _porTipView = [[AAIIQATakePhotoPorTipView alloc] init];
            }
            _porTipView.translatesAutoresizingMaskIntoConstraints = NO;
        }
        
        if (_porTipView.superview == nil) {
            [self addSubview:_porTipView];
        }
        
        if (_porCons == nil) {
            _porCons = @[
                [_porTipView.topAnchor constraintEqualToAnchor:self.topAnchor],
                [_porTipView.leftAnchor constraintEqualToAnchor:self.leftAnchor],
                [_porTipView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
                [_porTipView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor],
            ];
        }
        
        [NSLayoutConstraint activateConstraints:_porCons];
    } else {
        // Remove _porTipView
        if (_porTipView != nil && [_porTipView superview] != nil) {
            [NSLayoutConstraint deactivateConstraints:_porCons];
            [_porTipView removeFromSuperview];
        }
        
        if (_lanTipView == nil) {
            id<AAIIQATakePhotoTipViewDataSource> lanTipViewDS = [AAIGlobalIQAInternalConfig shareConfig].originConfig.takePhotoTipViewDataSource;
            if (lanTipViewDS) {
                if ([lanTipViewDS respondsToSelector:@selector(iqaCreateTakePhotoTipView:)]) {
                    _lanTipView = [lanTipViewDS iqaCreateTakePhotoTipView:NO];
                }
            }
            if (!_lanTipView) {
                _lanTipView = [[AAIIQATakePhotoLanTipView alloc] init];
            }
            
            _lanTipView.translatesAutoresizingMaskIntoConstraints = NO;
        }
        
        if (_lanTipView.superview == nil) {
            [self addSubview:_lanTipView];
        }
        
        if (_lanCons == nil) {
            _lanCons = @[
                [_lanTipView.topAnchor constraintEqualToAnchor:self.topAnchor],
                [_lanTipView.leftAnchor constraintEqualToAnchor:self.leftAnchor],
                [_lanTipView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
                [_lanTipView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor],
            ];
        }
        [NSLayoutConstraint activateConstraints:_lanCons];
    }
}

- (BOOL)isPortrait
{
    return _portrait;
}

@end
