//
//  AAIIQATakePhotoMainView.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/24.
//

#import "AAIIQATakePhotoMainViewInternal.h"
#import "AAIIQACommUtil.h"
#import "AAIIQATakePhotoTipView.h"
#import "AAIIQATakePhotoButton.h"
#import "AAIGlobalIQAInternalConfig.h"
#import "AAIIQAAlertView.h"
#import <AAIGlobalIQASDK/AAIIQATimer.h>

@interface AAIIQATakePhotoMainView()
{
    AAIIQATakePhotoTipView *_tpTipView;
    NSArray<NSLayoutConstraint *> *_tpTipViewPorCons;
    NSArray<NSLayoutConstraint *> *_tpTipViewLanCons;
    
    AAIIQATakePhotoButton *_takePhotoBtnView;
    NSArray<NSLayoutConstraint *> *_tpBtnPorCons;
    NSArray<NSLayoutConstraint *> *_tpBtnLanCons;
    
    UIImage *_previewImg;
    UIImage *_scaledImg;
}
@end
@implementation AAIIQATakePhotoMainView

- (void)updateTakePhotoTipViewLayout:(BOOL)isPortrait
{
    if (_tpTipView == nil) {
        _tpTipView = [AAIIQATakePhotoTipView tipWithIfPortrait:isPortrait];
        _tpTipView.translatesAutoresizingMaskIntoConstraints = NO;
    }
    
    if (_tpTipView.superview == nil) {
        [self addSubview:_tpTipView];
    }
    
    BOOL preIsPortrait = _tpTipView.portrait;
    _tpTipView.portrait = isPortrait;
    
    if (isPortrait) {
        if (!preIsPortrait) {
            // Deactive landscape constranits
            if (_tpTipViewLanCons != nil) {
                [NSLayoutConstraint deactivateConstraints:_tpTipViewLanCons];
            }
        }
        
        if (_tpTipViewPorCons == nil) {
            _tpTipViewPorCons = @[
                [_tpTipView.topAnchor constraintEqualToAnchor:self.iqaView.bottomAnchor constant:10],
                [_tpTipView.leftAnchor constraintEqualToAnchor:self.iqaView.leftAnchor],
                [_tpTipView.rightAnchor constraintEqualToAnchor:self.iqaView.rightAnchor],
            ];
        }
        [NSLayoutConstraint activateConstraints:_tpTipViewPorCons];
    } else {
        // Deactive portrait constranits
        if (preIsPortrait) {
            if (_tpTipViewPorCons != nil) {
                [NSLayoutConstraint deactivateConstraints:_tpTipViewPorCons];
            }
        }
        
        [self.viewfinderView setNeedsDisplay];
        if (_tpTipViewLanCons == nil) {
            _tpTipViewLanCons = @[
                [_tpTipView.centerXAnchor constraintEqualToAnchor:self.centerXAnchor],
                [_tpTipView.bottomAnchor constraintEqualToAnchor:self.iqaView.bottomAnchor constant:-12]
            ];
        }
        [NSLayoutConstraint activateConstraints:_tpTipViewLanCons];
    }
}

- (void)updateTakePhotoBtnViewLayout:(BOOL)isPortrait
{
    if (_takePhotoBtnView == nil) {
        _takePhotoBtnView = [[AAIIQATakePhotoButton alloc] initWithIfPortrait:isPortrait];
        _takePhotoBtnView.translatesAutoresizingMaskIntoConstraints = NO;
        [_takePhotoBtnView.button addTarget:self action:@selector(tapTakePhotoBtnAction) forControlEvents:UIControlEventTouchUpInside];
    }
    
    if (_takePhotoBtnView.superview == nil) {
        [self addSubview:_takePhotoBtnView];
    }
    
    BOOL preIsPortrait = _takePhotoBtnView.portrait;
    _takePhotoBtnView.portrait = isPortrait;
    
    if (isPortrait) {
        if (!preIsPortrait) {
            // Deactive landscape constranits
            if (_tpBtnLanCons != nil) {
                [NSLayoutConstraint deactivateConstraints:_tpBtnLanCons];
            }
        }
        
        if (_tpBtnPorCons == nil) {
            _tpBtnPorCons = @[
                [_takePhotoBtnView.topAnchor constraintEqualToAnchor:self.iqaView.bottomAnchor],
                [_takePhotoBtnView.centerXAnchor constraintEqualToAnchor:self.centerXAnchor],
                [_takePhotoBtnView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor],
            ];
            _tpBtnPorCons.lastObject.priority = UILayoutPriorityDefaultLow;
        }
        [NSLayoutConstraint activateConstraints:_tpBtnPorCons];
    } else {
        // Deactive portrait constranits
        if (preIsPortrait) {
            if (_tpBtnPorCons != nil) {
                [NSLayoutConstraint deactivateConstraints:_tpBtnPorCons];
            }
        }
        
        if (_tpBtnLanCons == nil) {
            _tpBtnLanCons = @[
                [_takePhotoBtnView.leftAnchor constraintEqualToAnchor:self.iqaView.rightAnchor],
                [_takePhotoBtnView.centerYAnchor constraintEqualToAnchor:self.centerYAnchor],
                [_takePhotoBtnView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
            ];
            _tpBtnLanCons.lastObject.priority = UILayoutPriorityDefaultLow;
        }
        [NSLayoutConstraint activateConstraints:_tpBtnLanCons];
    }
}

- (void)willTransitionToOrientation:(UIDeviceOrientation)orientation
{
    [super willTransitionToOrientation:orientation];
    
    if (UIDeviceOrientationIsPortrait(orientation)) {
        [self updateAdditionalViewsLayout: YES];
    }  else if (UIDeviceOrientationIsLandscape(orientation)) {
        [self updateAdditionalViewsLayout: NO];
    }
}

- (void)updateAdditionalViewsLayout:(BOOL)isPortrait
{
    AAIIQAState state = self.viewModel.state;
    switch (state) {
        case AAIIQAStateTakePhoto: {
            AAIGlobalIQAUIConfig *uiConfig = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig;
            if (uiConfig.takePhotoButtonVisible) {
                // Show takePhoto button
                if (_takePhotoBtnView) {
                    _takePhotoBtnView.hidden = NO;
                }
                [self updateTakePhotoBtnViewLayout:isPortrait];
            }
            
            if (uiConfig.takePhotoTipViewVisible) {
                // Show take photo tipView
                if (_tpTipView) {
                    _tpTipView.hidden = NO;
                }
                [self updateTakePhotoTipViewLayout:isPortrait];
            }
            
            // Show IQA view
            self.iqaView.hidden = NO;
            self.topDescView.hidden = NO;
        } break;
        case AAIIQAStateTakePhotoBegin: {
            
        } break;
        case AAIIQAStateTakePhotoDone: {
            
        } break;
        default:
            break;
    }
    
}

- (void)tapTakePhotoBtnAction
{
    self.viewModel.state = AAIIQAStateTakePhotoBegin;
    // Note: the capturePhoto must be called after the state is set to AAIIQAStateTakePhotoBegin
    [self.iqaView capturePhoto];
}

- (void)tapContinueBtnAction
{
    self.viewModel.state = AAIIQAStateCaptureImgDone;
    
    [self.iqaView useCapturedPhoto];
}

- (void)takePhotoModeImgDidCaptured:(UIImage *)rawSizeImg scaledImg:(UIImage *)scaledImg
{
    [super takePhotoModeImgDidCaptured:rawSizeImg scaledImg:scaledImg];
    
    _previewImg = rawSizeImg;
    _scaledImg = scaledImg;
    
    self.viewModel.state = AAIIQAStateTakePhotoDone;
}

- (void)detectionTimeout:(AAIGlobalIQAResult *)originalResult
{
    [super detectionTimeout:originalResult];
    
    self.viewModel.scanMode = NO;
}

- (void)sdkStateDidChanged:(AAIIQAState)newState
{
    [super sdkStateDidChanged:newState];
    
    if (newState == AAIIQAStateDetectionTimeout) {
        self.viewModel.scanMode = NO;
        
        [self tryEnterTakePhotoPage];
    } else if (newState == AAIIQAStateTakePhotoDone) {
        
    } else {
        BOOL isPortrait = [AAIIQACommUtil isPortraitOrientation];
        AAIIQAOrientation customOrien = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig.orientation;
        if (customOrien != AAIIQAOrientationAuto) {
            isPortrait = (customOrien == AAIIQAOrientationLandscape) ? NO : YES;
        }
        [self updateAdditionalViewsLayout:isPortrait];
    }
}

- (void)tryEnterTakePhotoPage
{
    __block NSInteger count = [AAIGlobalIQAInternalConfig shareConfig].originConfig.takePhotoAlertViewTimeoutInterval;
    if (count > 0) {
        AAIIQAAlertView *alertView = [[AAIIQAAlertView alloc] init];
        alertView.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:alertView];
        NSArray<NSLayoutConstraint *> *cons = @[
            [alertView.topAnchor constraintEqualToAnchor:self.topAnchor],
            [alertView.leftAnchor constraintEqualToAnchor:self.leftAnchor],
            [alertView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor],
            [alertView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
        ];
        [NSLayoutConstraint activateConstraints:cons];
        [alertView showWithAnimation];
        
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"
        alertView.countLabel.text = [NSString stringWithFormat:@"%lds", (long)count];
        AAIIQATimer *t = [[AAIIQATimer alloc] initWithTimeInterval:1 repeats:YES action:^(AAIIQATimer * _Nonnull timer) {
            count--;
            alertView.countLabel.text = [NSString stringWithFormat:@"%lds", (long)count];
            if (count == 0) {
                [alertView removeFromSuperview];
                //                self.viewModel.state = AAIIQAStateTakePhoto;
                [self startPhotoMode];
                [timer invalidate];
            }
        }];
#pragma clang diagnostic pop
    } else {
        //        self.viewModel.state = AAIIQAStateTakePhoto;
        [self startPhotoMode];
    }
}



@end
