//
//  AAIIQATakePhotoButton.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/24.
//

#import "AAIIQATakePhotoButton.h"
#import "AAIIQACommUtil.h"

@interface AAIIQATakePhotoButton()
{
    NSArray<NSLayoutConstraint *> *_porCons;
    NSArray<NSLayoutConstraint *> *_lanCons;
}
@end
@implementation AAIIQATakePhotoButton

- (instancetype)initWithIfPortrait:(BOOL)isPortrait
{
    self = [super initWithFrame:CGRectZero];
    if (self) {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
        UIImage *img = [AAIIQACommUtil imgWithName:@"iqa_take_photo"];
        [btn setImage:img forState:UIControlStateNormal];
        [self addSubview:btn];
        btn.translatesAutoresizingMaskIntoConstraints = NO;
        
        _button = btn;
        
        self.portrait = isPortrait;
    }
    return self;
}

- (void)setPortrait:(BOOL)portrait
{
    _portrait = portrait;
    
    UIImage *img = [_button imageForState:UIControlStateNormal];
    if (portrait) {
        if (_lanCons != nil) {
            [NSLayoutConstraint deactivateConstraints:_lanCons];
        }
        
        if (_porCons == nil) {
            CGSize screenSize = [AAIIQACommUtil currScreenSize];
            CGFloat lenMax = screenSize.height;
            CGFloat offsetY = 0;
            if (lenMax < 667) {
                offsetY = 20;
            }
            _porCons = @[
                [_button.widthAnchor constraintEqualToConstant:img.size.width],
                [_button.heightAnchor constraintEqualToConstant:img.size.height],
                [self.leftAnchor constraintEqualToAnchor:_button.leftAnchor],
                [self.rightAnchor constraintEqualToAnchor:_button.rightAnchor],
                [_button.centerYAnchor constraintEqualToAnchor:self.centerYAnchor constant:offsetY],
            ];
        }
        
        [NSLayoutConstraint activateConstraints:_porCons];
    } else {
        if (_porCons != nil) {
            [NSLayoutConstraint deactivateConstraints:_porCons];
        }
        
        if (_lanCons == nil) {
            _lanCons = @[
                [_button.widthAnchor constraintEqualToConstant:img.size.width],
                [_button.heightAnchor constraintEqualToConstant:img.size.height],
                [self.topAnchor constraintEqualToAnchor:_button.topAnchor],
                [self.bottomAnchor constraintEqualToAnchor:_button.bottomAnchor],
                [_button.centerXAnchor constraintEqualToAnchor:self.centerXAnchor],
            ];
        }
        
        [NSLayoutConstraint activateConstraints:_lanCons];
    }
    
}

@end
