//
//  AAIIQAScanMainView.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/10.
//

#import <UIKit/UIKit.h>
#import "AAIIQAMainViewModel.h"
#import "AAIIQANavBarView.h"
#import "AAIIQATipView.h"
#import "AAIIQAMaskView.h"
#import "AAIIQAScanMainView.h"
#import "AAIIQACommUtil.h"
#import "AAIIQADispositionType.h"
#import <AAIGlobalIQASDK/AAIIQACameraWrapperViewDelegate.h>
#import <AAIGlobalIQASDK/AAIIQACameraWrapperView.h>

NS_ASSUME_NONNULL_BEGIN

@interface AAIIQAScanMainView () <AAIIQACameraWrapperViewScanModeDelegate, AAIIQACameraWrapperViewPhotoModeDelegate>
{
    BOOL _hasAddedObserver;
    AAIIQAMainViewModel *_viewModel;

    AAIIQAExtButton *_flashBtn;
    AAIIQAExtButton *_cycleCameraBtn;

    UILabel *_cardSideLabel;
    UIStackView *_topStackView;
    NSLayoutConstraint *_topStackViewBottomPorCons;
    NSLayoutConstraint *_topStackViewBottomLanCons;

    UILabel *_timeLabel;

    //
    NSArray<NSLayoutConstraint *> *_tipViewPorCons;
    NSArray<NSLayoutConstraint *> *_tipViewLanCons;

    NSInteger _consumeTimes;

    AAIIQACommUtil *_util;
}

@property(nonatomic, copy) NSArray<NSLayoutConstraint *> *iqaViewPorCons;
@property(nonatomic, copy) NSArray<NSLayoutConstraint *> *iqaViewLanCons;

@property(nonatomic, strong) UIView *topDescView;
@property(nonatomic, strong) AAIIQACameraWrapperView *iqaView;
@property(nonatomic, strong) AAIIQANavBarView *navView;
@property(nonatomic, strong) AAIIQATipView *tipView;
@property(nonatomic, strong) AAIIQAMaskView *viewfinderView;

@property(nonatomic, readonly) AAIIQAMainViewModel *viewModel;

@property(nonatomic, copy, nullable) void (^tapNavBackBtnBlk)(AAIIQAScanMainView *mainView);
@property(nonatomic, copy, nullable) void (^deviceNotSupportBlk)(AAIIQAScanMainView *mainView);

@property(nonatomic, copy, nullable) void (^onDetectionComplete)(id<AAIGlobalIQAResultProtocol> result);
@property(nonatomic, copy, nullable) void (^onScanTimeout)(AAIIQAScanMainView *mainView, NSInteger remainingRetryTimes);

@property(nonatomic, copy, nullable) void (^onAuthStart)(AAIIQAScanMainView *);
@property(nonatomic, copy, nullable) void (^onAuthFinish)(AAIIQAScanMainView *, NSError *_Nullable error);
@property(nonatomic, copy, nullable) void (^onUploadStart)(AAIIQAScanMainView *);
@property(nonatomic, copy, nullable) void (^onUploadFinish)(AAIIQAScanMainView *, NSError *_Nullable error);

@property(nonatomic, copy) void (^onTakePhotoDone)(UIImage *previewImg, AAIIQAScanMainView *rawView);
@property(nonatomic, copy) AVCaptureVideoOrientation (^iqaGetPreferredVideoOrientation)(AAIIQAScanMainView *);
@property(nonatomic, nullable) NSLayoutConstraint * (^loadCameraViewPortCons)(AAIIQAScanMainView *mainView, UIView *cameraView);

- (void)loadCameraView;
- (void)loadAdditionalUI;

- (void)bindViewModel:(AAIIQAMainViewModel *)viewModel;

- (void)willTransitionToOrientation:(UIDeviceOrientation)orientation;

- (void)startRunning;
- (void)stopRunning;

- (void)startPhotoMode;
- (void)discardCapturedPhoto;

- (void)detectionTimeout:(AAIGlobalIQAResult *)originalResult;

- (void)takePhotoModeImgDidCaptured:(UIImage *)rawSizeImg scaledImg:(UIImage *)scaledImg;
- (void)sdkStateDidChanged:(AAIIQAState)newState;

- (NSInteger)retryTimes;

@end

NS_ASSUME_NONNULL_END
