//
//  AAIIQARetakeToolbar.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/24.
//

#import "AAIIQARetakeToolbar.h"
#import "AAIIQACommUtil.h"

@interface AAIIQARetakeToolbar()
{
    UIStackView *_porStackView;
    UIStackView *_lanStackView;
    
    NSArray<NSLayoutConstraint *> *_porCons;
    NSArray<NSLayoutConstraint *> *_lanCons;
}

@end
@implementation AAIIQARetakeToolbar

- (instancetype)initWithIfPortrait:(BOOL)isPortrait
{
    self = [super initWithFrame:CGRectZero];
    if (self) {
        
    }
    return self;
}

- (void)setPortrait:(BOOL)portrait
{
    _portrait = portrait;
    
    if (portrait) {
        // Remove _lanTipView
        if (_lanStackView != nil && [_lanStackView superview] != nil) {
            [NSLayoutConstraint deactivateConstraints:_lanCons];
            [_lanStackView removeFromSuperview];
        }
        
        // Add _porTipView
        if (_porStackView == nil) {
            UIButton *retakeBtn = [AAIIQACommUtil borderButtonWithTitle:[AAIIQACommUtil localStrForKey:@"iqa_retake"]];
            UIButton *continueBtn = [AAIIQACommUtil buttonWithTitle:[AAIIQACommUtil localStrForKey:@"iqa_continue"]];
            [retakeBtn addTarget:self action:@selector(tapRetakeBtn:) forControlEvents:UIControlEventTouchUpInside];
            [continueBtn addTarget:self action:@selector(tapContinueBtn:) forControlEvents:UIControlEventTouchUpInside];
            _porStackView = [[UIStackView alloc] initWithArrangedSubviews:@[retakeBtn, continueBtn]];
            _porStackView.axis = UILayoutConstraintAxisHorizontal;
            _porStackView.distribution = UIStackViewDistributionFillEqually;
            _porStackView.spacing = 21;
            _porStackView.translatesAutoresizingMaskIntoConstraints = NO;
        }
        
        if (_porStackView.superview == nil) {
            [self addSubview:_porStackView];
        }
        
        if (_porCons == nil) {
            _porCons = @[
                [_porStackView.topAnchor constraintEqualToAnchor:self.topAnchor],
                [_porStackView.leftAnchor constraintEqualToAnchor:self.leftAnchor],
                [_porStackView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
                [_porStackView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor],
            ];
        }
        
        [NSLayoutConstraint activateConstraints:_porCons];
    } else {
        // Remove _porTipView
        if (_porStackView != nil && [_porStackView superview] != nil) {
            [NSLayoutConstraint deactivateConstraints:_porCons];
            [_porStackView removeFromSuperview];
        }
        
        if (_lanStackView == nil) {
            UIImage *retakeImg = [AAIIQACommUtil imgWithName:@"iqa_land_retake"];
            UIImage *continueImg = [AAIIQACommUtil imgWithName:@"iqa_land_confirm"];;
            UIButton *retakeBtn = [AAIIQACommUtil porButtonWithTitle:[AAIIQACommUtil localStrForKey:@"iqa_retake"] img:retakeImg];
            UIButton *continueBtn = [AAIIQACommUtil porButtonWithTitle:[AAIIQACommUtil localStrForKey:@"iqa_continue"] img:continueImg];
            _lanStackView = [[UIStackView alloc] initWithArrangedSubviews:@[retakeBtn,continueBtn]];
            _lanStackView.axis = UILayoutConstraintAxisVertical;
            _lanStackView.distribution = UIStackViewDistributionEqualSpacing;
            _lanStackView.translatesAutoresizingMaskIntoConstraints = NO;
            _lanStackView.alignment = UIStackViewAlignmentCenter;
            
            [retakeBtn addTarget:self action:@selector(tapRetakeBtn:) forControlEvents:UIControlEventTouchUpInside];
            [continueBtn addTarget:self action:@selector(tapContinueBtn:) forControlEvents:UIControlEventTouchUpInside];
        }

        if (_lanStackView.superview == nil) {
            [self addSubview:_lanStackView];
        }

        if (_lanCons == nil) {
            _lanCons = @[
                [_lanStackView.topAnchor constraintEqualToAnchor:self.topAnchor],
                [_lanStackView.leftAnchor constraintEqualToAnchor:self.leftAnchor],
                [_lanStackView.rightAnchor constraintEqualToAnchor:self.rightAnchor],
                [_lanStackView.bottomAnchor constraintEqualToAnchor:self.bottomAnchor]
            ];
        }
        
        [NSLayoutConstraint activateConstraints:_lanCons];
    }
}

- (void)tapRetakeBtn:(UIButton *)button
{
    if (self.tapRetakeBtnBlk) {
        self.tapRetakeBtnBlk(button);
    }
}

- (void)tapContinueBtn:(UIButton *)button
{
    if (self.tapContinueBtnBlk) {
        self.tapContinueBtnBlk(button);
    }
}

@end
