//
//  AAIIQAViewfinderView.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/13.
//

#import "AAIIQAOverlayView.h"
#import "AAIIQACommUtil.h"
#import "AAIGlobalIQAInternalConfig.h"

@implementation AAIIQAOverlayView

- (void)drawRect:(CGRect)rect
{
    CGContextRef context = UIGraphicsGetCurrentContext();
    
    CGFloat lineWidth = 4.0f;
    AAIGlobalIQAInternalConfig *config = [AAIGlobalIQAInternalConfig shareConfig];
    CGContextSaveGState(context);
    CGContextSetFillColorWithColor(context, self.maskColor.CGColor);
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRect:rect];
    CGRect innerRect = CGRectInset(rect, lineWidth/2, lineWidth/2);
    UIBezierPath *innerRectPath = [UIBezierPath bezierPathWithRect:innerRect];
    [maskPath appendPath:innerRectPath];
    maskPath.usesEvenOddFillRule = YES;
    CGContextAddPath(context, maskPath.CGPath);
    CGContextEOFillPath(context);
    CGContextRestoreGState(context);
    
    CGContextSetLineWidth(context, 1);
    CGContextSetLineCap(context, kCGLineCapSquare);
    
    CGFloat lineLength = 20;
    CGRect bottomRect = innerRect;
    CGContextSetStrokeColorWithColor(context, config.originConfig.uiConfig.viewfinderColor.CGColor);
    CGContextAddRect(context, bottomRect);
    CGContextStrokePath(context);
    
    CGPoint origin = bottomRect.origin;
    CGSize size = bottomRect.size;
    
    CGContextSetLineWidth(context, lineWidth);
    
    // Left top (bottom > top -> right)
    CGContextMoveToPoint(context, origin.x, origin.y + lineLength);
    CGContextAddLineToPoint(context, origin.x, origin.y);
    CGContextAddLineToPoint(context, origin.x + lineLength, origin.y);
    
    // Left bottom (top > bottom -> right)
    CGContextMoveToPoint(context, origin.x, origin.y + size.height - lineLength);
    CGContextAddLineToPoint(context, origin.x, origin.y + size.height);
    CGContextAddLineToPoint(context, origin.x + lineLength, origin.y + size.height);
    
    // Right bottom (left -> right -> top)
    CGContextMoveToPoint(context, origin.x + size.width - lineLength, origin.y + size.height);
    CGContextAddLineToPoint(context, origin.x + size.width, origin.y + size.height);
    CGContextAddLineToPoint(context, origin.x + size.width, origin.y + size.height - lineLength);
    
    // Right top (bottom -> top -> left)
    CGContextMoveToPoint(context, origin.x + size.width, origin.y + lineLength);
    CGContextAddLineToPoint(context, origin.x + size.width, origin.y);
    CGContextAddLineToPoint(context, origin.x + size.width - lineLength, origin.y);
    
    CGContextStrokePath(context);
}

@end
