//
//  AAIIQANavBarView.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/12.
//

#import "AAIIQANavBarView.h"
#import "AAIIQACommUtil.h"

@implementation AAIIQAExtButton

- (BOOL)pointInside:(CGPoint)point withEvent:(UIEvent *)event
{
    CGRect bounds = self.bounds;
    CGFloat widthDelta = MAX(_touchExtSize.width - bounds.size.width, 0);
    CGFloat heightDelta = MAX(_touchExtSize.height - bounds.size.height, 0);
    return CGRectContainsPoint(CGRectInset(bounds, -0.5 * widthDelta, -0.5 * heightDelta), point);
}

@end

@interface AAIIQANavBarView()
{
    UIView *_contentView;
    NSLayoutConstraint *_titleRightCons;
}
@property(nonatomic, readwrite) UIButton *backBtn;
@property(nonatomic, readwrite) UILabel *titleLabel;
@property(nonatomic, readwrite) NSMutableArray<UIControl *> *barItems;
@end
@implementation AAIIQANavBarView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        UIView *contentView = [[UIView alloc] init];
        
        // Back button
        UIImage *backImg = [AAIIQACommUtil imgWithName:@"iqa_back"];
        AAIIQAExtButton *backBtn = [AAIIQAExtButton buttonWithType:UIButtonTypeCustom];
        backBtn.touchExtSize = CGSizeMake(44, 40);
        [backBtn setImage:backImg forState:UIControlStateNormal];
        backBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [contentView addSubview:backBtn];
        
        // Title
        UILabel *titleLabel = [[UILabel alloc] init];
        titleLabel.font = [AAIIQACommUtil fontWithSize:18 isBold:YES];
        titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        titleLabel.textColor = [AAIIQACommUtil colorWithHexRGB:0x333333 alpha:1];
        [contentView addSubview:titleLabel];
        
        [self addSubview:contentView];
        contentView.translatesAutoresizingMaskIntoConstraints = NO;
        NSArray *cons = @[
            [backBtn.widthAnchor constraintEqualToConstant:backImg.size.width],
            [backBtn.heightAnchor constraintEqualToConstant:backImg.size.height],
            [backBtn.leftAnchor constraintEqualToAnchor:contentView.leftAnchor constant:21],
            [backBtn.centerYAnchor constraintEqualToAnchor:contentView.centerYAnchor],
            
            [titleLabel.leftAnchor constraintGreaterThanOrEqualToAnchor:backBtn.rightAnchor constant:21],
            [titleLabel.centerXAnchor constraintEqualToAnchor:contentView.centerXAnchor],
            [titleLabel.centerYAnchor constraintEqualToAnchor:contentView.centerYAnchor],
            
            [AAIIQACommUtil topContraintOf:contentView toSV:self constant:0],
            [AAIIQACommUtil leftContraintOf:contentView toSV:self constant:0],
            [AAIIQACommUtil rightContraintOf:contentView toSV:self constant:0],
            [contentView.heightAnchor constraintEqualToConstant:44],
            [self.bottomAnchor constraintEqualToAnchor:contentView.bottomAnchor]
        ];
        [NSLayoutConstraint activateConstraints:cons];
        
        _contentView = contentView;
        _backBtn = backBtn;
        _titleLabel = titleLabel;
        
        [_backBtn addTarget:self action:@selector(tapBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    }
    return self;
}

- (void)tapBtnAction:(UIButton *)btn
{
    if (btn == _backBtn) {
        if (self.tapBackBtnBlk) {
            self.tapBackBtnBlk(self);
        }
    }
}

- (void)pushBarItem:(UIControl *)item marginRight:(CGFloat)marginRight
{
    if (!item) return;
    
    item.translatesAutoresizingMaskIntoConstraints = NO;
    UIView *sv = _contentView;
    [sv addSubview:item];
    
    NSLayoutConstraint *centerYCon = [item.centerYAnchor constraintEqualToAnchor:sv.centerYAnchor];
    NSLayoutConstraint *rightCons = nil;
    if (_barItems == nil || _barItems.count == 0) {
        if (_barItems == nil) {
            _barItems = [[NSMutableArray alloc] init];
        }
        
        rightCons = [item.rightAnchor constraintEqualToAnchor:sv.rightAnchor constant:-21];
    } else {
        UIControl *topItem = _barItems.lastObject;
        rightCons = [item.rightAnchor constraintEqualToAnchor:topItem.leftAnchor constant:-28];
    }
    
    if (_titleRightCons) {
        _titleRightCons.active = NO;
    }
    _titleRightCons = [_titleLabel.rightAnchor constraintLessThanOrEqualToAnchor:item.leftAnchor constant:-21];
    
    NSArray *cons = @[centerYCon, rightCons, _titleRightCons];
    [NSLayoutConstraint activateConstraints:cons];
    
    [_barItems addObject:item];
}

@end
