//
//  AAIIQAMaskView.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/7/1.
//

#import "AAIIQAMaskView.h"
#import "AAIIQAOverlayView.h"
#import "AAIIQACommUtil.h"
#import "AAIGlobalIQAInternalConfig.h"

@interface AAIIQAMaskView()
{
    AAIIQAOverlayView *_vfView;
    UIImageView *_scanImgView;
    BOOL _beginAnimating;
    BOOL _isAnimating;
    CGFloat _preWidth;
}
@end
@implementation AAIIQAMaskView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        UIView *sv = self;
        
        UIImageView *scanImgView = [[UIImageView alloc] init];
        UIImage *scImg = [AAIIQACommUtil imgWithName:@"advance_iqa_scan"];
        scanImgView.image = scImg;
        [sv addSubview:scanImgView];
        scanImgView.contentMode = UIViewContentModeScaleToFill;
        _scanImgView = scanImgView;
        
        Class overlayClz = [[AAIGlobalIQAInternalConfig shareConfig].originConfig classOfModuleType:AAIIQAModuleTypeOverlayViewOfScanVC];
        AAIIQAOverlayView *vfView = [[overlayClz alloc] init];
        vfView.backgroundColor = [UIColor clearColor];
        vfView.translatesAutoresizingMaskIntoConstraints = NO;
        [sv addSubview:vfView];
        NSArray<NSLayoutConstraint *> *vfCons = @[
            [vfView.topAnchor constraintEqualToAnchor:sv.topAnchor],
            [vfView.leftAnchor constraintEqualToAnchor:sv.leftAnchor],
            [vfView.bottomAnchor constraintEqualToAnchor:sv.bottomAnchor],
            [vfView.rightAnchor constraintEqualToAnchor:sv.rightAnchor],
        ];
        [NSLayoutConstraint activateConstraints:vfCons];
        _vfView = vfView;
    }
    return self;
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    
    // Redraw viewfinder after screen rotation
    [_vfView setNeedsDisplay];
    [self updateScanAnimation];
}

- (void)setMaskColor:(UIColor *)maskColor
{
    _maskColor = maskColor;
    _vfView.maskColor = maskColor;
}

- (void)startAnimation
{
    _beginAnimating = YES;
    
    _scanImgView.hidden = NO;
    
    [self updateScanAnimation];
}

- (void)stopAnimation
{
    [_scanImgView.layer removeAnimationForKey:@"txa"];
    _scanImgView.hidden = YES;
    _isAnimating = NO;
}

- (void)updateScanAnimation
{
    CGFloat width = self.bounds.size.width;
    if (width <= 0) {
        return;
    }
    
    CGRect vfRect = self.bounds;
    CGSize imgSize = _scanImgView.image.size;
    _scanImgView.frame = CGRectMake(vfRect.origin.x - _scanImgView.frame.size.width, (self.bounds.size.height - vfRect.size.height)/2, imgSize.width, vfRect.size.height);
    if (_beginAnimating) {
        if (!_isAnimating) {
            CABasicAnimation *animation = [self moveFrom:@(0) to:@(vfRect.size.width + _scanImgView.frame.size.width)];
            [_scanImgView.layer addAnimation:animation forKey:@"txa"];
            _isAnimating = YES;
            _preWidth = width;
        } else {
            // The orientation has changed, so we need to update the animation.
            if (ABS(_preWidth - width) > 0.1) {
                [_scanImgView.layer removeAnimationForKey:@"txa"];
                CABasicAnimation *animation = [self moveFrom:@(0) to:@(vfRect.size.width + _scanImgView.frame.size.width)];
                [_scanImgView.layer addAnimation:animation forKey:@"txa"];
                _preWidth = width;
            }
        }
    }
}
- (CABasicAnimation *)moveFrom:(NSNumber *)from to:(NSNumber *)to
{
    CABasicAnimation *animationMove = [CABasicAnimation animationWithKeyPath:@"transform.translation.x"];
    animationMove.fromValue = from;
    animationMove.toValue = to;
    animationMove.duration = 2;
    animationMove.repeatCount = HUGE_VALF;
    animationMove.fillMode = kCAFillModeForwards;
    animationMove.removedOnCompletion = NO;
    animationMove.timingFunction = [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionLinear];
    return animationMove;
}

@end

