//
//  AAIHUD.m
//  UIDemo
//
//  Created by Advance.ai on 2019/3/8.
//  Copyright © 2019 Liveness.AI.Advance. All rights reserved.
//

#import "AAIIQAHUD.h"
#import "AAIIQACommUtil.h"

@interface AAIIQAHUD()
@property(nonatomic, strong) UIActivityIndicatorView *indicatorView;
@property(nonatomic, strong) UILabel *msgLabel;
@end

@implementation AAIIQAHUD

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        UIView *sv = self;
        UIActivityIndicatorView *indicatorView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
        [sv addSubview:indicatorView];
        _indicatorView = indicatorView;
        
        UILabel *label = [[UILabel alloc] init];
        label.font = [AAIIQACommUtil fontWithSize:14 isBold:NO];
        label.textColor = [UIColor whiteColor];
        label.numberOfLines = 0;
        label.textAlignment = NSTextAlignmentCenter;
        [sv addSubview:label];
        _msgLabel = label;
        
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(orientationChanged:) name:UIDeviceOrientationDidChangeNotification object:nil];
    }
    return self;
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIDeviceOrientationDidChangeNotification object:nil];
}

- (void)orientationChanged:(NSNotification *)notif
{
    CGSize screenSize = [UIScreen mainScreen].bounds.size;
    CGSize size = [self sizeThatFits:screenSize];
    self.bounds = CGRectMake(0, 0, size.width, size.height);
    self.center = CGPointMake(screenSize.width/2, screenSize.height/2);
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    [self sizeThatFits:[UIScreen mainScreen].bounds.size];
}

- (CGSize)sizeThatFits:(CGSize)size
{
    CGFloat imgWidth = 37, marginLeft = 14, marginTop = 18, padding = 8, minWidth = 120;
    _msgLabel.preferredMaxLayoutWidth = size.width - 2 * marginLeft - padding;
    CGSize labelSize = [_msgLabel sizeThatFits:CGSizeMake(_msgLabel.preferredMaxLayoutWidth, size.height)];
    
    CGFloat width = labelSize.width + 2 * marginLeft;
    if (width < _msgLabel.preferredMaxLayoutWidth) {
        if (width < (imgWidth + 2 * marginLeft)) {
            width = imgWidth + 2 * marginLeft;
        }
    }
    if (width < minWidth) {
        width = minWidth;
    }
    
    CGFloat height = marginTop;
    CGFloat top = 0;
    if (_indicatorView.hidden == NO) {
        _indicatorView.frame = CGRectMake((width - imgWidth)/2, marginTop, imgWidth, imgWidth);
        height += imgWidth;
        if (_msgLabel.hidden == NO) {
            height += padding;
        }
        top = CGRectGetMaxY(_indicatorView.frame);
    } else {
        top = marginTop;
    }
    
    if (_msgLabel.hidden == NO) {
        if (_indicatorView.hidden == NO) {
            top += padding;
        }
        _msgLabel.frame = CGRectMake((width - labelSize.width)/2, top, labelSize.width, labelSize.height);
        height += labelSize.height;
    }
    
    height += marginTop;
    if (height > size.height) {
        height = size.height;
    }
    
    return CGSizeMake(width, height);
}

+ (void)showWaitWithMsg:(NSString *)msg onView:(UIView *)sv
{
    [self dismissHUDOnView:sv];
    
    AAIIQAHUD *hud = [self createHUDIfNeeded:sv];
    
    hud.indicatorView.hidden = NO;
    [hud.indicatorView startAnimating];
    hud.msgLabel.text = msg;
    
    CGSize screenSize = [UIScreen mainScreen].bounds.size;
    CGSize size = [hud sizeThatFits:screenSize];
    hud.bounds = CGRectMake(0, 0, size.width, size.height);
    hud.center = CGPointMake(screenSize.width/2, screenSize.height/2);
    
    hud.alpha = 0;
    [UIView animateWithDuration:0.3 animations:^{
        hud.alpha = 1;
    }];
}

+ (AAIIQAHUD *)hudForView:(UIView *)sv
{
    NSEnumerator *subviewsEnum = [sv.subviews reverseObjectEnumerator];
    for (UIView *subview in subviewsEnum) {
        if ([subview isKindOfClass:self]) {
            AAIIQAHUD *hud = (AAIIQAHUD *)subview;
            return hud;
        }
    }
    return nil;
}

+ (AAIIQAHUD *)createHUDIfNeeded:(UIView *)sv
{
    AAIIQAHUD *hud = [self hudForView:sv];
    if (!hud) {
        hud = [[AAIIQAHUD alloc] initWithFrame:CGRectZero];
        hud.backgroundColor =  [UIColor colorWithRed:(0x20/255.f) green:(0x20/255.f) blue:(0x20/255.f) alpha:0.86];
        [sv addSubview:hud];
    }
    hud.layer.cornerRadius = 4;
    return hud;
}

+ (void)showMsg:(NSString *)msg onView:(UIView *)sv
{
    [self dismissHUDOnView:sv];
    
    AAIIQAHUD *hud = [self createHUDIfNeeded:sv];
    hud.msgLabel.text = msg;
    hud.indicatorView.hidden = YES;
    
    CGSize screenSize = [UIScreen mainScreen].bounds.size;
    CGSize size = [hud sizeThatFits:screenSize];
    hud.bounds = CGRectMake(0, 0, size.width, size.height);
    hud.center = CGPointMake(screenSize.width/2, screenSize.height/2);
    
    hud.alpha = 0;
    [UIView animateWithDuration:0.3 animations:^{
        hud.alpha = 1;
    }];
}

+ (void)showMsg:(NSString *)msg onView:(UIView *)sv duration:(NSTimeInterval)interval
{
    [self showMsg:msg onView:sv];
    [self dismissHUDOnView:sv afterDelay:interval];
}

+ (void)dismissHUDOnView:(UIView *)sv
{
    AAIIQAHUD *hud = [self hudForView:sv];
    if (hud) {
        [hud removeFromSuperview];
    }
}

+ (void)dismissHUDOnView:(UIView *)sv afterDelay:(NSTimeInterval)interval
{
    AAIIQAHUD *hud = [self hudForView:sv];
    if (!hud) {
        return;
    }
    
    [UIView animateWithDuration:0.3 delay:interval options:UIViewAnimationOptionCurveEaseInOut animations:^{
        hud.alpha = 0;
    } completion:^(BOOL finished) {
        [hud removeFromSuperview];
    }];
}

@end
