//
//  AAIIQAAlertView.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/26.
//

#import "AAIIQAAlertView.h"
#import "AAIIQACommUtil.h"

@implementation AAIIQAAlertView

- (UIView *)createContentView
{
    UIView *sv = [[UIView alloc] init];
    sv.backgroundColor = UIColor.whiteColor;
    sv.layer.cornerRadius = 6;
    sv.layer.masksToBounds = YES;
    
    UIImageView *imgView = [[UIImageView alloc] initWithImage:[AAIIQACommUtil imgWithName:@"advance_iqa_tip_capture"]];
    [sv addSubview:imgView];
    
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.numberOfLines = 0;
    titleLabel.font = [AAIIQACommUtil fontWithSize:14 isBold:NO];
    titleLabel.textColor = [AAIIQACommUtil colorWithHexRGB:0x333333 alpha:1];
    titleLabel.text = [AAIIQACommUtil localStrForKey:@"iqa_time_out_tips"];
    [titleLabel setContentCompressionResistancePriority:UILayoutPriorityDefaultLow forAxis:UILayoutConstraintAxisHorizontal];
    [sv addSubview:titleLabel];
    
    UILabel *countLabel = [[UILabel alloc] init];
    countLabel.textColor = [AAIIQACommUtil colorWithHexRGB:0x30B043 alpha:1];
    countLabel.font = [AAIIQACommUtil fontWithSize:14 isBold:NO];
    [sv addSubview:countLabel];
    
    imgView.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    countLabel.translatesAutoresizingMaskIntoConstraints = NO;
    NSArray<NSLayoutConstraint *> *cons = @[
        [imgView.topAnchor constraintEqualToAnchor:sv.topAnchor constant:20],
        [imgView.widthAnchor constraintEqualToConstant:40],
        [imgView.heightAnchor constraintEqualToConstant:40],
        [imgView.centerXAnchor constraintEqualToAnchor:sv.centerXAnchor],
        
        [titleLabel.topAnchor constraintEqualToAnchor:imgView.bottomAnchor constant:20],
        [titleLabel.leftAnchor constraintEqualToAnchor:sv.leftAnchor constant:20],
        [countLabel.leftAnchor constraintEqualToAnchor:titleLabel.rightAnchor constant:20],
        [countLabel.rightAnchor constraintEqualToAnchor:sv.rightAnchor constant:-20],
        [countLabel.centerYAnchor constraintEqualToAnchor:titleLabel.centerYAnchor],
        
        [sv.bottomAnchor constraintEqualToAnchor:titleLabel.bottomAnchor constant:20]
    ];
    [NSLayoutConstraint activateConstraints:cons];
    
    _countLabel = countLabel;
    
    return sv;
}

- (void)showWithAnimation
{
    UIView *contentView = [self createContentView];
    contentView.translatesAutoresizingMaskIntoConstraints = NO;
    [self addSubview:contentView];
    NSArray<NSLayoutConstraint *> *cons = @[
        [contentView.centerXAnchor constraintEqualToAnchor:self.centerXAnchor],
        [contentView.widthAnchor constraintLessThanOrEqualToAnchor:self.widthAnchor constant:-40],
        [contentView.centerYAnchor constraintEqualToAnchor:self.centerYAnchor],
    ];
    [NSLayoutConstraint activateConstraints:cons];
    self.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0];
    contentView.alpha = 0;
    [UIView animateWithDuration:0.3 animations:^{
        self.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.4];
        contentView.alpha = 1;
    }];
}


@end
