//
//  AAIIQAMainViewModel.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/12.
//

#import "AAIIQAMainViewModel.h"
#import "AAIGlobalIQAInternalConfig.h"
#import "AAIIQACommUtil.h"
#import "AAIGlobalIQAResultInternal.h"

@interface AAIIQAMainViewModel()
@property(nonatomic) NSString *navBarTitle;
@end
@implementation AAIIQAMainViewModel

- (instancetype)init
{
    self = [super init];
    if (self) {
        _currCameraPosition = [self defaultCameraPosition];
        _flashButtonOff = YES;
        _flashButtonVisible = NO;
        _navBarTitle = @"Scan Document";
        _scanMode = YES;
    }
    return self;
}

- (AVCaptureDevicePosition)defaultCameraPosition
{
    // Try set back camera as default
    if ([self isSupportCameraPosition:AVCaptureDevicePositionBack]) {
        return AVCaptureDevicePositionBack;
    }
    
    if ([self isSupportCameraPosition:AVCaptureDevicePositionFront]) {
        return AVCaptureDevicePositionFront;
    }
    
    return AVCaptureDevicePositionUnspecified;
}

- (BOOL)isSupportCameraPosition:(AVCaptureDevicePosition)position
{
    NSArray *avaliableDevice = [AAIIQACommUtil avaliableCameraPositions];
    if (avaliableDevice == nil) {
        return NO;
    }
    
    BOOL isExist = NO;
    
    for (NSNumber *obj in avaliableDevice) {
        if (obj.integerValue == position) {
            isExist = YES;
        }
    }
    
    return isExist;
}

- (NSString *)navBarTitle
{
    if (_isPortrait) {
        _navBarTitle = [AAIIQACommUtil localStrForKey:@"iqa_scan_document"];
    } else {
        AAIIQACardSide cardSide = [AAIGlobalIQAInternalConfig shareConfig].cardSide;
        if (cardSide == AAIIQACardSideFront) {
            _navBarTitle = [AAIIQACommUtil localStrForKey:@"iqa_front_side_of_document"];
        } else if (cardSide == AAIIQACardSideBack) {
            _navBarTitle = [AAIIQACommUtil localStrForKey:@"iqa_back_side_of_document"];
        } else {
            _navBarTitle = @"";
        }
    }
    
    return _navBarTitle;
}

- (void)trySwitchCameraPostion
{
    if (_currCameraPosition == AVCaptureDevicePositionBack) {
        // If support front, then switch to front
        if ([self isSupportCameraPosition:AVCaptureDevicePositionFront]) {
            self.currCameraPosition = AVCaptureDevicePositionFront;
        }
    } else if (_currCameraPosition == AVCaptureDevicePositionFront) {
        // If support back, then switch to back
        if ([self isSupportCameraPosition:AVCaptureDevicePositionBack]) {
            self.currCameraPosition = AVCaptureDevicePositionBack;
        }
    }
}

- (AAIGlobalIQAResult *)resultWithErrorCode:(AAIIQAErrorCode)errorCode
{
    NSString *errorCodeStr = nil;
    if (errorCode == AAIIQAErrorCodeUserGiveUp) {
        errorCodeStr = @"USER_GIVE_UP";
    }
    return [self resultWithErrorCode:errorCode errorCodeStr:errorCodeStr];
}

- (AAIGlobalIQAResult *)resultWithErrorCode:(AAIIQAErrorCode)errorCode errorCodeStr:(NSString *)errorCodeStr
{
    AAIGlobalIQAResult *result = [[AAIGlobalIQAResult alloc] init];
    result.errorCodeEnumValue = errorCode;
    if (errorCodeStr) {
        result.errorCode = errorCodeStr;
    }
    if (_eLogId) {
        result.eventId = _eLogId;
    } else {
        result.eventId = @"";
    }
    
    return result;
}

@end
