//
//  AAIIQAMainViewModel.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/12.
//

#import <Foundation/Foundation.h>
#import "AAIGlobalIQAResult.h"
#import <AVFoundation/AVFoundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, AAIIQAState) {
    AAIIQAStateInit = 0,
    AAIIQAStateDetecting,
    AAIIQAStateDetectionSuccess,
    AAIIQAStateDetectionTimeout,
    AAIIQAStateTakePhoto,
    AAIIQAStateTakePhotoBegin,
    AAIIQAStateTakePhotoDone,
    AAIIQAStateCaptureImgDone
};

@interface AAIIQAMainViewModel : NSObject

@property(nonatomic) BOOL isPortrait;

@property(nonatomic, readonly) NSString *navBarTitle;

@property(nonatomic) AVCaptureDevicePosition currCameraPosition;

// navBarview could observe this property to update the flash button state
@property(nonatomic) BOOL flashButtonVisible;
@property(nonatomic) BOOL flashButtonOff;

@property(nonatomic) AAIIQAState state;

@property(nonatomic, getter=isScanMode) BOOL scanMode;

@property(nonatomic) NSString *eLogId;

- (AVCaptureDevicePosition)defaultCameraPosition;

- (void)trySwitchCameraPostion;

- (AAIGlobalIQAResult *)resultWithErrorCode:(AAIIQAErrorCode)errorCode;

@end

NS_ASSUME_NONNULL_END
