//
//  AAIGlobalIQAResultInternal.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2023/5/25.
//

#import <Foundation/Foundation.h>
#import "AAIGlobalIQAResult.h"

NS_ASSUME_NONNULL_BEGIN

@interface AAIGlobalIQAResult()

@property(nonatomic) BOOL success;
@property(nonatomic) BOOL pay;
@property(nonatomic, nullable) NSString *transactionId;
@property(nonatomic) NSString *eventId;
@property(nonatomic) AAIIQAErrorCode errorCodeEnumValue;

@property(nonatomic, nullable) NSString *errorCode;
@property(nonatomic, nullable) NSString *errorMsg;
@property(nonatomic, nullable) NSString *cardImgBase64String;

@property(nonatomic, nullable) UIImage *cardImg;
@property(nonatomic, nullable) NSString *IDVID;

@property(nonatomic, nullable) NSDictionary *idForgeryResult;
@property(nonatomic, nullable) NSDictionary *ocrResult;
@property(nonatomic, nullable) NSString *pictureType;

- (NSError * _Nullable)toNSError;

@end

NS_ASSUME_NONNULL_END
