//
//  AAIGlobalIQAResult.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2023/5/25.
//

#import "AAIGlobalIQAResultInternal.h"

@implementation AAIGlobalIQAResult

+ (AAIGlobalIQAResult *)copyFromResult:(id<AAIGlobalIQAResultProtocol>)result
{
    AAIGlobalIQAResult *newResult = [[AAIGlobalIQAResult alloc] init];
    newResult.success = result.success;
    newResult.pay = result.pay;
    newResult.transactionId = result.transactionId;
    newResult.eventId = result.eventId;
    newResult.errorCodeEnumValue = result.errorCodeEnumValue;
    newResult.errorCode = result.errorCode;
    newResult.errorMsg = result.errorMsg;
    newResult.cardImgBase64String = result.cardImgBase64String;
    newResult.cardImg = result.cardImg;
    newResult.IDVID = result.IDVID;
    newResult.idForgeryResult = result.idForgeryResult;
    newResult.ocrResult = result.ocrResult;
    newResult.pictureType = result.pictureType;
    return newResult;
}

- (NSError * _Nullable)toNSError
{
    if (self.success) return nil;
    
    NSString *tid = self.transactionId;
    if (!tid) { tid = @"";}
    
    NSString *errorCode = self.errorCode;
    if (!errorCode) { errorCode = @""; }
    
    NSString *errorMsg = self.errorMsg;
    if (!errorMsg) { errorMsg = @""; }
    
    NSString *eventId = self.eventId;
    if (!eventId) { eventId = @""; }
    
    NSDictionary *userInfo = @{
        @"transactionId": tid,
        @"errorCode": errorCode,
        @"errorMsg": errorMsg,
        @"eventId": eventId
    };
    
    return [NSError errorWithDomain:@"com.aai.iqa" code:-1 userInfo:userInfo];
}

@end
