//
//  AAIGlobalIQASDK+DefaultUI.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2025/7/17.
//

#import "AAIGlobalIQASDK+DefaultUI.h"
#import "AAIGlobalIQAInternalConfig.h"
#import "AAIIQACommUtil.h"
#import "AAIIQANavController.h"
#import "AAIIQAScanController.h"

@implementation AAIGlobalIQASDK (DefaultUI)

+ (void)initWithConfig:(AAIGlobalIQAConfig *)config
{
    // Initialize the core module first
    [AAIGlobalIQASDK initSDK];
    
    AAIGlobalIQAInternalConfig *internalConfig = [AAIGlobalIQAInternalConfig shareConfig];
    if (config != nil) {
        internalConfig.originConfig = config;
        internalConfig.region = config.region;
        internalConfig.cardType = config.cardType;
        internalConfig.cardSide = config.cardSide;
        internalConfig.detectionTimeoutInterval = config.detectionTimeoutInterval;
        internalConfig.returnEmptyOfOCR = config.returnEmptyOfOCR;
    }
    
    // Reset
    internalConfig.userId = nil;
    [AAIIQACommUtil resetLanCache];
}

+ (AAIGlobalIQAConfig *)sdkConfig
{
    AAIGlobalIQAInternalConfig *internalConfig = [AAIGlobalIQAInternalConfig shareConfig];
    return internalConfig.originConfig;
}

+ (void)startWithRootVC:(UIViewController *)rootVC
{
    [self startWithRootVC:rootVC completionBlk:^(AAIGlobalIQAResult *result){}];
}

+ (void)startWithRootVC:(UIViewController *)rootVC completionBlk:(void (^)(AAIGlobalIQAResult *))completionBlk
{
    [self checkSupportOriention: rootVC];
    UINavigationController *naVC = [self createSDKNavigationController];
    [AAIGlobalIQAInternalConfig shareConfig].completionBlk = completionBlk;
    [rootVC showViewController:naVC sender:nil];
}

+ (void)checkSupportOriention:(UIViewController *)controller {
    
    AAIIQAOrientation orientation = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig.orientation;
    
    if (orientation == AAIIQAOrientationAuto) {
        return;
    }
    
    UIApplication *app = [UIApplication sharedApplication];
    UIInterfaceOrientationMask supportedOrientations = [app supportedInterfaceOrientationsForWindow:controller.view.window];
    
    // Check if the app supports specified orientation
    BOOL supportsPortrait = supportedOrientations & UIInterfaceOrientationMaskPortrait;
    BOOL supportsLandscapeLeft = supportedOrientations & UIInterfaceOrientationMaskLandscapeLeft;
    BOOL supportsLandscapeRight = supportedOrientations & UIInterfaceOrientationMaskLandscapeRight;
    BOOL supportsLandscape = supportsLandscapeLeft || supportsLandscapeRight;
    
    if (orientation == AAIIQAOrientationLandscape && !supportsLandscape) {
        [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig.orientation = AAIIQAOrientationAuto;
        NSLog(@"Warning⚠️: your project not support landscape orientation");
        return;
    }
    
    if (orientation == AAIIQAOrientationPortrait && !supportsPortrait) {
        NSLog(@"Warning⚠️: your project not support portrait orientation");
        [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig.orientation = AAIIQAOrientationAuto;
        return;
    }
    
}

+ (UINavigationController *)createSDKNavigationController
{
    Class scanClz = [[AAIGlobalIQAInternalConfig shareConfig].originConfig classOfModuleType:AAIIQAModuleTypeScanController];
    AAIIQAScanController *mainVC = [[scanClz alloc] init];
    AAIIQANavController *naVC = [[AAIIQANavController alloc] initWithRootViewController:mainVC];
    naVC.navigationBarHidden = YES;
    naVC.modalPresentationStyle = UIModalPresentationFullScreen;
    return naVC;
}

@end
