//
//  AAIIQAPreviewImgController.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/6/30.
//

#import "AAIIQAPreviewImgController.h"
#import "AAIIQACommUtil.h"
#import "AAIGlobalIQAInternalConfig.h"
#import "AAIIQANavBarView.h"
#import "AAIIQARetakeToolbar.h"
#import "AAIIQALog.h"

@interface AAIIQAPreviewImgController ()
{
    AAIIQANavBarView *_navBarView;
    
    NSArray<NSLayoutConstraint *> *_imgPorCons;
    NSArray<NSLayoutConstraint *> *_imgLanCons;
    
    NSArray<NSLayoutConstraint *> *_btPorCons;
    NSArray<NSLayoutConstraint *> *_btLanCons;
    
    UIImageView *_imgView;
    AAIIQAOverlayView *_overlayView;
    UIView *_bottomTipView;
    
    AAIIQARetakeToolbar *_retakeToolbar;
    NSArray<NSLayoutConstraint *> *_tpToolBarPorCons;
    NSArray<NSLayoutConstraint *> *_tpToolBarLanCons;
    
    NSMutableArray<NSLayoutConstraint *> *_allDeactiveCons;
    NSMutableArray<NSLayoutConstraint *> *_allActiveCons;
}
@end

@implementation AAIIQAPreviewImgController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self loadSDKUI];
}

- (void)viewWillTransitionToSize:(CGSize)size withTransitionCoordinator:(id<UIViewControllerTransitionCoordinator>)coordinator
{
    if (!_allDeactiveCons) return;
    if (!_allActiveCons) return;
    
    BOOL isPortrait = [AAIIQACommUtil isPortraitOrientation];
    AAIIQAOrientation customOrien = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig.orientation;
    if (customOrien != AAIIQAOrientationAuto) {
        isPortrait = (customOrien == AAIIQAOrientationLandscape) ? NO : YES;
    }
    [self updateAdditionalViewsLayout:isPortrait];
    [_overlayView setNeedsDisplay];
    [super viewWillTransitionToSize:size withTransitionCoordinator:coordinator];
}

#pragma mark - properties
- (void)setPreviewImage:(UIImage *)previewImage
{
    _previewImage = previewImage;
    if (_imgView) {
        _imgView.image = previewImage;
    }
}

- (UIImageView *)previewImgView
{
    return _imgView;
}

- (AAIIQAOverlayView *)overlayView
{
    return _overlayView;
}

- (UIView *)navBarView
{
    return _navBarView;
}

- (UIView *)tipView
{
    return _bottomTipView;
}

- (UIView *)retakeToolbar
{
    return _retakeToolbar;
}

#pragma mark - public
- (void)loadSDKUI
{
    _allDeactiveCons = [[NSMutableArray alloc] init];
    _allActiveCons = [[NSMutableArray alloc] init];
    
    UIView *sv = self.view;
    __weak typeof(self) weakSelf = self;
    
    // 1. NavBar
    AAIIQANavBarView *navView = [[AAIIQANavBarView alloc] init];
    navView.translatesAutoresizingMaskIntoConstraints = NO;
    [sv addSubview:navView];
    NSArray *navbarCons = @[
        [navView.topAnchor constraintEqualToAnchor:sv.topAnchor],
        [navView.leftAnchor constraintEqualToAnchor:sv.leftAnchor],
        [navView.rightAnchor constraintEqualToAnchor:sv.rightAnchor],
    ];
    [NSLayoutConstraint activateConstraints:navbarCons];
    
    AAIGlobalIQAUIConfig *uiConfig = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig;
    NSAttributedString *navAttrTitle = uiConfig.navBarAttrTitle;
    if (!navAttrTitle) {
        navView.titleLabel.text = self.title;
    } else {
        navView.titleLabel.attributedText = navAttrTitle;
    }
    
    navView.tapBackBtnBlk = ^(AAIIQANavBarView * _Nonnull navBarView) {
        if (weakSelf.tapNavBackBtnBlk) {
            weakSelf.tapNavBackBtnBlk(weakSelf);
        }
    };
    _navBarView = navView;
    
    // 2. Add preview image view
    UIImageView *imgView = [[UIImageView alloc] init];
    imgView.translatesAutoresizingMaskIntoConstraints = NO;
    [sv addSubview:imgView];
    
    // 2.1. Add overlay view
    Class overlayClz = [[AAIGlobalIQAInternalConfig shareConfig].originConfig classOfModuleType:AAIIQAModuleTypeOverlayViewOfPreviewImgVC];
    AAIIQAOverlayView *olView = [[overlayClz alloc] init];
    olView.backgroundColor = [UIColor clearColor];
    olView.maskColor = uiConfig.pageBackgroundColor;
    [imgView addSubview:olView];
    olView.translatesAutoresizingMaskIntoConstraints = NO;
    NSArray<NSLayoutConstraint *> *vfCons = @[
        [olView.topAnchor constraintEqualToAnchor:imgView.topAnchor],
        [olView.leftAnchor constraintEqualToAnchor:imgView.leftAnchor],
        [olView.bottomAnchor constraintEqualToAnchor:imgView.bottomAnchor],
        [olView.rightAnchor constraintEqualToAnchor:imgView.rightAnchor],
    ];
    [NSLayoutConstraint activateConstraints:vfCons];
    
    // 3. Add bottom label view
    UIView *bottomTipView = [self createBottomTipView];
    bottomTipView.translatesAutoresizingMaskIntoConstraints = NO;
    [sv addSubview:bottomTipView];
    
    imgView.image = _previewImage;
    _imgView = imgView;
    _bottomTipView = bottomTipView;
    _overlayView = olView;
    
    BOOL isPortrait = [AAIIQACommUtil isPortraitOrientation];
    AAIIQAOrientation customOrien = uiConfig.orientation;
    if (customOrien != AAIIQAOrientationAuto) {
        isPortrait = (customOrien == AAIIQAOrientationLandscape) ? NO : YES;
    }
    [self updateAdditionalViewsLayout:isPortrait];
}

#pragma mark - private
- (UIView *)createBottomTipView
{
    AAIGlobalIQAUIConfig *uiConfig = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig;
    UIView *sv = [[UIView alloc] init];
    sv.backgroundColor = uiConfig.previewPhotoTipBackgroundColor;
    sv.layer.cornerRadius = 2;
    sv.layer.masksToBounds = YES;
    
    NSLayoutXAxisAnchor *leftAnchor = sv.leftAnchor;
    if (uiConfig.previewPhotoTipLeftIconVisible) {
        CGFloat iLabelWidth = 16;
        UILabel *iLabel = [[UILabel alloc] init];
        iLabel.text = @"i";
        iLabel.font = [AAIIQACommUtil fontWithSize:14 isBold:NO];
        iLabel.textColor = [UIColor whiteColor];
        iLabel.textAlignment = NSTextAlignmentCenter;
        iLabel.translatesAutoresizingMaskIntoConstraints = NO;
        iLabel.layer.cornerRadius = iLabelWidth/2;
        iLabel.layer.masksToBounds = YES;
        iLabel.backgroundColor = [AAIIQACommUtil colorWithHexRGB:0xAEBAB5 alpha:1];
        [sv addSubview:iLabel];
        
        NSArray *iLabelCons = @[
            [iLabel.leftAnchor constraintEqualToAnchor:sv.leftAnchor constant:8],
            [iLabel.widthAnchor constraintEqualToConstant:iLabelWidth],
            [iLabel.heightAnchor constraintEqualToConstant:iLabelWidth],
            [iLabel.centerYAnchor constraintEqualToAnchor:sv.centerYAnchor],
        ];
        [NSLayoutConstraint activateConstraints:iLabelCons];
        
        leftAnchor = iLabel.rightAnchor;
    } else {
        leftAnchor = sv.leftAnchor;
    }
    
    UILabel *descLabel = [[UILabel alloc] init];
    descLabel.numberOfLines = 0;
    
    if (!uiConfig.previewPhotoTipAttrText) {
        descLabel.text = [AAIIQACommUtil localStrForKey:@"iqa_take_photo_ensure"];
        descLabel.font = [AAIIQACommUtil fontWithSize:14 isBold:NO];
        descLabel.textColor = uiConfig.previewPhotoTipTextColor;
    } else {
        descLabel.attributedText = uiConfig.previewPhotoTipAttrText;
    }
    
    descLabel.translatesAutoresizingMaskIntoConstraints = NO;
    [sv addSubview:descLabel];
    
    NSArray *descLabelCons = @[
        [descLabel.leftAnchor constraintEqualToAnchor:leftAnchor constant:8],
        [descLabel.topAnchor constraintEqualToAnchor:sv.topAnchor constant:11],
        [descLabel.rightAnchor constraintEqualToAnchor:sv.rightAnchor constant:-8],
        [descLabel.bottomAnchor constraintEqualToAnchor:sv.bottomAnchor constant:-11],
    ];
    [NSLayoutConstraint activateConstraints:descLabelCons];
    
    return sv;
}

- (void)updateAdditionalViewsLayout:(BOOL)isPortrait
{
    [_allActiveCons removeAllObjects];
    [_allDeactiveCons removeAllObjects];
    
    UIView *sv = self.view;
    UIImageView *imgView = _imgView;
    UIView *btView = _bottomTipView;
    
    if (isPortrait) {
        // 1. Update imageView constraints
        if (_imgLanCons) {
            [_allDeactiveCons addObjectsFromArray:_imgLanCons];
        }
        
        if (!_imgPorCons) {
            AAIGlobalIQAInternalConfig *config = [AAIGlobalIQAInternalConfig shareConfig];
            _imgPorCons = @[
                [imgView.topAnchor constraintEqualToAnchor:_navBarView.bottomAnchor constant:30],
                [imgView.widthAnchor constraintEqualToAnchor:sv.widthAnchor multiplier:(1 - 2 * config.finalLRPaddingRatio)],
                [imgView.heightAnchor constraintEqualToAnchor:imgView.widthAnchor multiplier:0.625 constant:0],
                [imgView.centerXAnchor constraintEqualToAnchor:sv.centerXAnchor]
            ];
        }
        [_allActiveCons addObjectsFromArray:_imgPorCons];
        
        // 2. Update bottomTipView constraints
        if (_btLanCons) {
            [_allDeactiveCons addObjectsFromArray:_btLanCons];
        }
        
        if (!_btPorCons) {
            _btPorCons = @[
                [btView.topAnchor constraintEqualToAnchor:imgView.bottomAnchor constant:16],
                [btView.leftAnchor constraintEqualToAnchor:imgView.leftAnchor],
                [btView.rightAnchor constraintEqualToAnchor:imgView.rightAnchor],
                [btView.centerXAnchor constraintEqualToAnchor:sv.centerXAnchor],
            ];
        }
        [_allActiveCons addObjectsFromArray:_btPorCons];
        
    } else {
        // 1. Update imageView constraints
        if (_imgPorCons) {
            [_allDeactiveCons addObjectsFromArray:_imgPorCons];
        }
        
        if (!_imgLanCons) {
            _imgLanCons = @[
                [imgView.heightAnchor constraintEqualToAnchor:sv.heightAnchor multiplier:1 constant:-106],
                [imgView.widthAnchor constraintEqualToAnchor:imgView.heightAnchor multiplier:1.55],
                [imgView.centerYAnchor constraintEqualToAnchor:sv.centerYAnchor constant:20],
                [imgView.centerXAnchor constraintEqualToAnchor:sv.centerXAnchor constant:0],
            ];
        }
        [_allActiveCons addObjectsFromArray:_imgLanCons];
        
        // 2. Update bottomTipView constraints
        if (_btPorCons) {
            [_allDeactiveCons addObjectsFromArray:_btPorCons];
        }
        
        if (!_btLanCons) {
            _btLanCons = @[
                [btView.bottomAnchor constraintEqualToAnchor:imgView.bottomAnchor constant:-12],
                [btView.centerXAnchor constraintEqualToAnchor:sv.centerXAnchor],
                [btView.leftAnchor constraintGreaterThanOrEqualToAnchor:imgView.leftAnchor],
                [btView.rightAnchor constraintLessThanOrEqualToAnchor:imgView.rightAnchor]
            ];
        }
        [_allActiveCons addObjectsFromArray:_btLanCons];
    }
    
    [NSLayoutConstraint deactivateConstraints:_allDeactiveCons];
    [NSLayoutConstraint activateConstraints:_allActiveCons];
    
    [self updateTakePhotoToolBarLayout:isPortrait];
}

- (void)updateTakePhotoToolBarLayout:(BOOL)isPortrait
{
    UIView *sv = self.view;
    if (_retakeToolbar == nil) {
        _retakeToolbar = [[AAIIQARetakeToolbar alloc] initWithIfPortrait:isPortrait];
        _retakeToolbar.translatesAutoresizingMaskIntoConstraints = NO;
        [sv addSubview:_retakeToolbar];
        
        __weak typeof(self) weakSelf = self;
        _retakeToolbar.tapRetakeBtnBlk = ^(UIButton * _Nonnull btn) {
            [weakSelf p_tapRetakeBtnAction: btn];
        };
        _retakeToolbar.tapContinueBtnBlk = ^(UIButton * _Nonnull btn) {
            [weakSelf p_tapContinueBtnAction: btn];
        };
    }
    
    BOOL preIsPortrait = _retakeToolbar.portrait;
    _retakeToolbar.portrait = isPortrait;
    
    if (isPortrait) {
        if (!preIsPortrait) {
            // Deactive landscape constranits
            if (_tpToolBarLanCons != nil) {
                [NSLayoutConstraint deactivateConstraints:_tpToolBarLanCons];
            }
        }
        
        if (_tpToolBarPorCons == nil) {
            CGFloat widthRatio = 1 - [[AAIGlobalIQAInternalConfig shareConfig] edgeLRPaddingRatio];
            _tpToolBarPorCons = @[
                [_retakeToolbar.widthAnchor constraintEqualToAnchor:sv.widthAnchor multiplier:widthRatio],
                [_retakeToolbar.centerXAnchor constraintEqualToAnchor:sv.centerXAnchor],
                [AAIIQACommUtil bottomContraintOf:_retakeToolbar toSV:sv constant:-20]
            ];
            _tpToolBarPorCons.lastObject.priority = UILayoutPriorityDefaultLow;
        }
        [NSLayoutConstraint activateConstraints:_tpToolBarPorCons];
    } else {
        // Deactive portrait constranits
        if (preIsPortrait) {
            if (_tpToolBarPorCons != nil) {
                [NSLayoutConstraint deactivateConstraints:_tpToolBarPorCons];
            }
        }
        
        if (_tpToolBarLanCons == nil) {
            _tpToolBarLanCons = @[
                [_retakeToolbar.heightAnchor constraintEqualToAnchor:_imgView.heightAnchor],
                [AAIIQACommUtil rightContraintOf:_retakeToolbar toSV:sv constant:-40],
                [_retakeToolbar.centerYAnchor constraintEqualToAnchor:_imgView.centerYAnchor],
            ];
        }
        [NSLayoutConstraint activateConstraints:_tpToolBarLanCons];
    }
}

- (void)p_tapContinueBtnAction:(UIButton *)btn
{
    if (self.tapContinueBtnBlk) {
        self.tapContinueBtnBlk(self);
    }
}

- (void)p_tapRetakeBtnAction:(UIButton *)btn
{
    if (self.tapRetakeBtnBlk) {
        self.tapRetakeBtnBlk(self);
    }
}

- (void)dealloc
{
    TLOG(@"Release AAIIQAPreviewPhotoController");
}

@end
