//
//  AAIIQABaseViewController.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/6/30.
//

#import "AAIIQABaseViewController.h"
#import "AAIGlobalIQAInternalConfig.h"

@interface AAIIQABaseViewController ()

@end

@implementation AAIIQABaseViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    AAIGlobalIQAUIConfig *uiConfig = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig;
    self.view.backgroundColor = uiConfig.pageBackgroundColor;
}

- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    AAIIQAOrientation orientation = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig.orientation;
    if (orientation == AAIIQAOrientationAuto) {
        return [super supportedInterfaceOrientations];
    } else if (orientation == AAIIQAOrientationPortrait) {
        return UIInterfaceOrientationMaskPortrait;
    } else {
        return UIInterfaceOrientationMaskLandscape;
    }
}

- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation
{
    AAIIQAOrientation orientation = [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig.orientation;
    if (orientation == AAIIQAOrientationAuto) {
        return [super preferredInterfaceOrientationForPresentation];
    } else if (orientation == AAIIQAOrientationPortrait) {
        return UIInterfaceOrientationPortrait;
    } else {
        UIInterfaceOrientation iOrientation = [[UIApplication sharedApplication] statusBarOrientation];
        if (iOrientation == UIInterfaceOrientationLandscapeLeft || iOrientation == UIInterfaceOrientationLandscapeRight) {
            return iOrientation;
        } else {
            return UIInterfaceOrientationLandscapeRight;
        }
    }
}

- (UIStatusBarStyle)preferredStatusBarStyle
{
    return [AAIGlobalIQAInternalConfig shareConfig].originConfig.uiConfig.statusBarStyle;
}

@end
