//
//  AAIGlobalIQAInternalConfig.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/4.
//

#import "AAIGlobalIQAInternalConfig.h"

@interface AAIGlobalIQAInternalConfig()
{
    CGFloat _modelMinSize;
    CGFloat _defaultOutputImgMinSize;
}
@end
@implementation AAIGlobalIQAInternalConfig

+ (instancetype)shareConfig
{
    static AAIGlobalIQAInternalConfig *shareObj;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareObj = [[AAIGlobalIQAInternalConfig alloc] init];
        shareObj.edgeLRPaddingRatio = 0.1;
        shareObj.edgeTBPaddingRatio = 0.1;
    });
    
    return shareObj;
}

- (CGRect)viewfinderRectOfPreviewRect:(CGRect)previewRect
{
    CGFloat dx = previewRect.size.width * [self edgeLRPaddingRatio];
    CGFloat dy = previewRect.size.height * [self edgeTBPaddingRatio];
    return CGRectInset(previewRect, dx, dy);
}

- (CGSize)scaledSizeOfRawSize:(CGSize)rawSize scaleType:(AAIIQAScaleType)scaleType
{
    float minSize = 0;
    if (scaleType == AAIIQAScaleTypeModel) {
        // min size for model image
        minSize = _modelMinSize;
    } else {
        if (_outputImgMaxSize > 0) {
            CGFloat minSize = MIN(rawSize.width, rawSize.height);
            if (minSize > _outputImgMaxSize) {
                // The following code is to reduce precision errors:
                // Due to the precision issues of floating-point operations
                // and the downward rounding behavior of the floorf function,
                // the final values of finalWidth or finalHeight may be less than _outputImgMaxSize.
                CGFloat scale = _outputImgMaxSize/minSize;
                CGFloat finalWidth, finalHeight;
                if (minSize == rawSize.width) {
                    finalWidth = _outputImgMaxSize;
                    finalHeight = rawSize.height * scale;
                } else {
                    finalHeight = _outputImgMaxSize;
                    finalWidth = rawSize.width * scale;
                }
                // round down finalWidth and finalHeight
                finalWidth = floorf(finalWidth);
                finalHeight = floorf(finalHeight);
                return CGSizeMake(finalWidth, finalHeight);
            } else {
                return rawSize;
            }
        } else {
            minSize = _defaultOutputImgMinSize;
        }
    }
    
    float scale = minSize/MIN(rawSize.width, rawSize.height);
    // Convert to integer to avoid precision issues
    return CGSizeMake(roundf(rawSize.width * scale), roundf(rawSize.height * scale));
}

- (NSString *)cardTypeString
{
    return [self stringValueOfCardType:self.cardType];
}

- (NSString *)cardSideString
{
    return [self stringValueOfCardSide:self.cardSide];
}

- (NSString *)region
{
    return [_originConfig.region copy];
}

- (NSString *)stringValueOfCardType:(AAIIQACardType)cardType
{
    switch (cardType) {
        case AAIIQACardTypeIDCard:
            return @"ID_CARD";
        case AAIIQACardTypeDrivingLicense:
            return @"DRIVING_LICENSE";
        case AAIIQACardTypeUMID:
            return @"UMID";
        case AAIIQACardTypeSSS:
            return @"SSS";
        case AAIIQACardTypeTIN:
            return @"TIN";
        case AAIIQACardTypePassport:
            return @"PASSPORT";
        case AAIIQACardTypeVOTERID:
            return @"VOTERID";
        case AAIIQACardTypeNATIONALID:
            return @"NATIONALID";
        case AAIIQACardTypePRC:
            return @"PRC";
        case AAIIQACardTypePAGIBG:
            return @"PAGIBIG";
        case AAIIQACardTypePAGIBIG:
            return @"PAGIBIG";
        case AAIIQACardTypePOSTALID:
            return @"POSTALID";
        default:
            return @"";
            break;
    }
}

- (NSString *)stringValueOfCardSide:(AAIIQACardSide)cardSide
{
    switch (cardSide) {
        case AAIIQACardSideBack:
            return @"BACK";
            break;
        case AAIIQACardSideFront:
            return @"FRONT";
            break;
        default:
            return @"";
            break;
    }
}

- (float)finalLRPaddingRatio
{
    AAIGlobalIQAInternalConfig *sharedObj = [self.class shareConfig];
    NSNumber *customMarginleft = sharedObj.originConfig.uiConfig.cameraViewMarginLRInPortraitMode;
    if (customMarginleft != nil) {
        CGFloat value = customMarginleft.floatValue;
        CGSize size =  [UIScreen mainScreen].bounds.size;
        CGFloat sw = MIN(size.width, size.height);
        return value/sw;
    } else {
        return self.edgeLRPaddingRatio;
    }
}

@end
