//
//  AAIGlobalIQAInternalConfig.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/4.
//

#import <UIKit/UIKit.h>
#import <AAIGlobalIQASDK/AAIIQAConstant.h>
#import <AVFoundation/AVCaptureSessionPreset.h>
#import "AAIGlobalIQAConfig.h"

typedef NS_ENUM(NSInteger, AAIIQAScaleType) {
    AAIIQAScaleTypeModel = 0,
    AAIIQAScaleTypeOutput = 1,
};

NS_ASSUME_NONNULL_BEGIN

@interface AAIGlobalIQAInternalConfig : NSObject

@property(nonatomic, strong) AAIGlobalIQAConfig *originConfig;

@property(nonatomic, copy) NSString *region;
@property(nonatomic) AAIIQACardType cardType;
@property(nonatomic) AAIIQACardSide cardSide;

@property(nonatomic) NSUInteger detectionTimeoutInterval;
@property(nonatomic) BOOL returnEmptyOfOCR;

@property(nonatomic) NSInteger outputImgMaxSize;

@property(nonatomic, copy, nullable) NSString *userId;

@property(nonatomic, readwrite) float edgeLRPaddingRatio;
@property(nonatomic, readwrite) float edgeTBPaddingRatio;

@property(nonatomic, readonly) float finalLRPaddingRatio;

@property(nonatomic, copy, nullable) void (^completionBlk)(AAIGlobalIQAResult *result);

+ (instancetype)shareConfig;

- (NSString *)cardTypeString;
- (NSString *)cardSideString;

@end

NS_ASSUME_NONNULL_END
