//
//  AAIGlobalIQAConfig.m
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/4.
//

#import "AAIGlobalIQAConfig.h"
#import "AAIIQACommUtil.h"

@implementation AAIGlobalIQAUIConfig

- (instancetype)init
{
    self = [super init];
    if (self) {
        _pageBackgroundColor = [AAIIQACommUtil colorWithHexRGB:0xF6F6F5 alpha:1];
        _navBarTitleTextColor = [AAIIQACommUtil colorWithHexRGB:0x333333 alpha:1];
        _navBarBackgroundColor = [UIColor clearColor];
        _navBarVisible = YES;
        _statusBarStyle = UIStatusBarStyleDefault;
        _primaryTextColor = [AAIIQACommUtil colorWithHexRGB:0x333333 alpha:1];
        _viewfinderColor = [AAIIQACommUtil colorWithHexRGB:0x333333 alpha:1];
        
        _takePhotoTipTextColor = [AAIIQACommUtil colorWithHexRGB:0x333333 alpha:1];
        _takePhotoTipBackgroundColor = [AAIIQACommUtil colorWithHexRGB:0xE0E0E0 alpha:0.8];
        _takePhotoTipLeftIconVisible = YES;
        _takePhotoTipViewVisible = YES;
        _takePhotoButtonVisible = YES;
        
        _previewPhotoTipTextColor = [AAIIQACommUtil colorWithHexRGB:0x333333 alpha:1];
        _previewPhotoTipBackgroundColor = [AAIIQACommUtil colorWithHexRGB:0xE0E0E0 alpha:0.8];
        
        _toolButtonThemeColor = [AAIIQACommUtil colorWithHexRGB:0x30B043 alpha:1];
        _flipCameraBtnVisible = YES;
        _topDescViewVisible = YES;
        _lightBtnVisible = YES;
        _tipIconVisible = YES;
        _tipViewVisible = YES;
        _timerLabelVisible = YES;
        _previewPhotoTipLeftIconVisible = YES;
        
        _orientation = AAIIQAOrientationAuto;
    }
    return self;
}

@end

#import "AAIIQAScanController.h"
#import "AAIIQAPreviewImgController.h"
#import "AAIIQAOverlayView.h"

@interface AAIGlobalIQAConfig()
{
    NSMutableDictionary<NSString*, Class> *_clsModuleMap;
}
@property(nonatomic, copy) NSString *region;
@property(nonatomic) AAIIQACardType cardType;
@property(nonatomic) AAIIQACardSide cardSide;
@property(nonatomic) AAIGlobalIQAUIConfig *uiConfig;
@end
@implementation AAIGlobalIQAConfig

+ (instancetype)initWithRegion:(NSString *)region cardType:(AAIIQACardType)cardType cardSide:(AAIIQACardSide)cardSide
{
    AAIGlobalIQAConfig *config = [[AAIGlobalIQAConfig alloc] init];
    config.detectionTimeoutInterval = 20;
    config.takePhotoAlertViewTimeoutInterval = 0;
    config.maxRetryTimes = 0;
    config.region = region;
    config.cardType = cardType;
    config.cardSide = cardSide;
    config.returnEmptyOfOCR = NO;
    config.callbackAfterPageDismissed = NO;
    config.uiConfig = [[AAIGlobalIQAUIConfig alloc] init];
    config.soundPlayEnable = YES;
    config.uiConfig.cameraViewMarginLRInPortraitMode = nil;
    config.operatingMode = AAIIQAOperatingModeDefault;
    
    NSMutableDictionary *moduleMap = [[NSMutableDictionary alloc] initWithCapacity:16];
    moduleMap[@(AAIIQAModuleTypeScanController).stringValue] = [AAIIQAScanController class];
    moduleMap[@(AAIIQAModuleTypePreviewImgController).stringValue] = [AAIIQAPreviewImgController class];
    moduleMap[@(AAIIQAModuleTypeOverlayViewOfScanVC).stringValue] = [AAIIQAOverlayView class];
    moduleMap[@(AAIIQAModuleTypeOverlayViewOfPreviewImgVC).stringValue] = [AAIIQAOverlayView class];
    
    config->_clsModuleMap = moduleMap;
    return config;
}

+ (instancetype)defaultConfig
{
    return [self initWithRegion:@"ID" cardType:AAIIQACardTypeIDCard cardSide:AAIIQACardSideFront];
}

- (void)registerClass:(Class)customClass forModule:(AAIIQAModuleType)moduleType
{
    Class finalClz = nil;
    if (customClass) {
        switch (moduleType) {
            case AAIIQAModuleTypeScanController: {
                if ([customClass isSubclassOfClass:[AAIIQAScanController class]]) {
                    finalClz = customClass;
                } else {
                    finalClz = [AAIIQAScanController class];
                }
            } break;
            case AAIIQAModuleTypePreviewImgController:{
                if ([customClass isSubclassOfClass:[AAIIQAPreviewImgController class]]) {
                    finalClz = customClass;
                } else {
                    finalClz = [AAIIQAPreviewImgController class];
                }
            } break;
            case AAIIQAModuleTypeOverlayViewOfScanVC:
            case AAIIQAModuleTypeOverlayViewOfPreviewImgVC: {
                if ([customClass isSubclassOfClass:[AAIIQAOverlayView class]]) {
                    finalClz = customClass;
                } else {
                    finalClz = [AAIIQAOverlayView class];
                }
            } break;
            default:
                break;
        }
        
        if (finalClz) {
            _clsModuleMap[@(moduleType).stringValue] = finalClz;
        }
        
    }
}

- (Class)classOfModuleType:(AAIIQAModuleType)moduleType
{
    return _clsModuleMap[@(moduleType).stringValue];
}

- (void)setPropertyValue:(id)value forPropertyKey:(NSString *)key
{
    if ([key isEqualToString:@"region"]) {
        if ([value isKindOfClass:[NSString class]]) {
            self.region = value;
        }
    } else if ([key isEqualToString:@"cardType"]) {
        if ([value isKindOfClass:[NSNumber class]]) {
            self.cardType = [value intValue];
        }
    } else if ([key isEqualToString:@"cardSide"]) {
        if ([value isKindOfClass:[NSNumber class]]) {
            self.cardSide = [value intValue];
        }
    }
}

- (void)setMaxRetryTimes:(NSInteger)maxRetryTimes
{
    _maxRetryTimes = maxRetryTimes > 0 ? maxRetryTimes : 0;
}

@end
