//
//  AAIIQAScanController.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/4.
//

#import <UIKit/UIKit.h>

#if __has_include(<AAIGlobalIQAUI/AAIIQABaseViewController.h>)
#import <AAIGlobalIQAUI/AAIIQABaseViewController.h>
#else
#import "AAIIQABaseViewController.h"
#endif

#if __has_include(<AAIGlobalIQAUI/AAIIQANavBarView.h>)
#import <AAIGlobalIQAUI/AAIIQANavBarView.h>
#else
#import "AAIIQANavBarView.h"
#endif

NS_ASSUME_NONNULL_BEGIN

/// A real-time detection of the card page and the photo page.
///
/// You can customize the UI by inheriting this class, then register your custom class to the sdk.
/// e.g.
/// @code
/// // Register your custom class to the SDK before call `[AAIGlobalIQASDK startWithRootVC:]`.
/// [config registerClass:[CustomScanController class] forModule:AAIIQAModuleTypeScanController];
/// @endcode
///
__attribute__((visibility("default")))
@interface AAIIQAScanController : AAIIQABaseViewController

@property(nonatomic, readonly, nullable) AAIIQANavBarView *navBarView;
@property(nonatomic, readonly, nullable) UIView *cameraView;

@property(nonatomic) BOOL flashOff;

/// This method internally creates all default UI controls for this page, it's called in "viewDidload" method.
/// Subclasses can override this method to fully customize the UI for this page.
- (void)loadSDKUI;

/// This method is automatically called when the 'loadCameraView' method is called.
/// You can override this method to customize the portrait constraint for the cameraView.
- (NSLayoutConstraint *_Nullable)loadCameraViewPortCons:(UIView *)cameraView;

/// Create and load cameraView.
- (void)loadCameraView;

/// You can call this method to close the SDK page.
- (void)closePage:(BOOL)animated;

/// You can override this method to show your customized loading view
- (void)beginRequest:(UIViewController *_Nullable)currVC;

/// You can override this method to dismiss your customized loading view
- (void)endRequest:(UIViewController *_Nullable)currVC;

@end

NS_ASSUME_NONNULL_END
