//
//  AAIIQAPreviewImgController.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/6/30.
//

#import <UIKit/UIKit.h>

#if __has_include(<AAIGlobalIQAUI/AAIIQABaseViewController.h>)
#import <AAIGlobalIQAUI/AAIIQABaseViewController.h>
#else
#import "AAIIQABaseViewController.h"
#endif

#if __has_include(<AAIGlobalIQAUI/AAIIQAOverlayView.h>)
#import <AAIGlobalIQAUI/AAIIQAOverlayView.h>
#else
#import "AAIIQAOverlayView.h"
#endif

#if __has_include(<AAIGlobalIQAUI/AAIIQANavBarView.h>)
#import <AAIGlobalIQAUI/AAIIQANavBarView.h>
#else
#import "AAIIQANavBarView.h"
#endif

NS_ASSUME_NONNULL_BEGIN

/// A page to preview the photos taken, this page will only appear in photo mode.
///
/// You can customize the UI by inheriting this class, then register your custom class to the sdk.
/// e.g.
/// @code
/// // Register your custom class to the SDK before call `[AAIGlobalIQASDK startWithRootVC:]`.
/// [config registerClass:[CustomPreviewImgController class] forModule:AAIIQAModuleTypePreviewImgController];
/// @endcode
///
/// @note If you want to  fully customize the UI for this page, you should override the method "loadSDKUI".
///
__attribute__((visibility("default")))
@interface AAIIQAPreviewImgController : AAIIQABaseViewController

@property(nonatomic, readonly, nullable) AAIIQANavBarView *navBarView;
@property(nonatomic, readonly, nullable) UIImageView *previewImgView;
@property(nonatomic, readonly, nullable) AAIIQAOverlayView *overlayView;

/// The view "Please ensure that all data on your documents is visible and readable."
/// If the default UI style does not meet your needs, you can hide it and then add your own tipView in a subclass of "AAIIQAPreviewImgController"
@property(nonatomic, readonly, nullable) UIView *tipView;

/// The default 'retakeToolbar' which is contain 'retake' button and 'continue' button.
@property(nonatomic, readonly, nullable) UIView *retakeToolbar;

/// The image to be previewed.
@property(nonatomic, nullable) UIImage *previewImage;

/// If you customize the back button of the navigation bar, you should call this method when your custom back button is clicked.
@property(nonatomic, copy, nullable) void (^tapNavBackBtnBlk)(AAIIQAPreviewImgController *rawVC);

/// If you customize the continue button, you should call this method when your custom continue button is clicked.
@property(nonatomic, copy, nullable) void (^tapContinueBtnBlk)(AAIIQAPreviewImgController *rawVC);

/// If you customize the retake button, you should call this method when your custom retake button is clicked.
@property(nonatomic, copy, nullable) void (^tapRetakeBtnBlk)(AAIIQAPreviewImgController *rawVC);

/// This method internally creates all default UI controls for this page, it's called in "viewDidload" method.
/// Subclasses can override this method to fully customize the UI for this page.
- (void)loadSDKUI;

@end

NS_ASSUME_NONNULL_END
