//
//  AAIIQAOverlayView.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/1/13.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/// A camera overlay view. The default is to draw graph in the drawRect.
///
/// You can customize the UI by inheriting this class, then register your custom class to the sdk.
/// e.g.
/// @code
/// // Register your custom class to the SDK before call `[AAIGlobalIQASDK startWithRootVC:]`.
///
/// // Customize the overlay view of `AAIIQAScanController`
/// [config registerClass:[CustomOverlayView class] forModule:AAIIQAModuleTypeOverlayViewOfScanVC];
///
/// // Customize the overlay view of `AAIIQAPreviewImgController`
/// [config registerClass:[CustomOverlayView class] forModule:AAIIQAModuleTypeOverlayViewOfScanVC];
/// @endcode
/// You can override the `drawRect` method to draw your custom graph, or just add your custom image view.
__attribute__((visibility("default")))
@interface AAIIQAOverlayView : UIView

@property(nonatomic) UIColor *maskColor;

@end

NS_ASSUME_NONNULL_END
