//
//  AAIIQADetectionDelegate.h
//  AAIGlobalIQASDK
//
//  Created by advance on 2022/9/19.
//

#import <Foundation/Foundation.h>
#import <AAIGlobalIQASDK/AAIIQAConstant.h>

NS_ASSUME_NONNULL_BEGIN

@protocol AAIIQADetectionDelegate <NSObject>

@optional

- (void)iqaOnDetectionStart;

- (void)iqaOnDetectionWarn:(AAIIQAWarnCode)warnCode;

- (void)iqaOnDetectionRemainTimeChanged:(NSInteger)remainTime totalTime:(NSInteger)totalTime contentView:(UIView *)contentView;

/// Tells the delegate that the detection timed out.
/// @param contentView AAIIQAScainMainView
/// @param consumeTimes The scan times
/// @param remainingRetryTimes The remaining available scan times
/// @param completionHandler A handler that tells the SDK what to do next. Note this handler must be called on the main thread.
///
/// You can implement this method to perform your additional action. After your action is complete, you must call the completeHandler to tells the SDK what to do next.
- (void)iqaOnDetectionTimeout:(UIView *)contentView
                 consumeTimes:(NSInteger)consumeTimes
          remainingRetryTimes:(NSInteger)remainingRetryTimes
            completionHandler:(void (^)(AAIIQADetectionTimeoutDisposition disposition))completionHandler;

/// Tell the delegate detection success.
/// @param rawImage Reserved field, currently this value is always nil.
- (void)iqaOnDetectionSucceed:(UIImage *_Nullable)rawImage;

/// Tell the delegate detection success and sdk will go to next step.
/// @param contextInfo Reserved field, currently this value is always nil.
/// @param contentView AAIIQAScainMainView
/// @param completionHandler A handler that tells the SDK what to do next. Note this handler must be called on the main thread.
///
/// You can implement this method to perform your additional action. After your action is complete, you must call the completeHandler to tells the SDK what to do next.
- (void)iqaOnDetectionSuccess:(NSDictionary *_Nullable)contextInfo
                  contentView:(UIView *)contentView
            completionHandler:(void (^)(AAIIQADetectionSuccessDisposition disposition))completionHandler;

@end

@protocol AAIIQATipViewDataSource <NSObject>

@required

- (UIView<AAIIQADetectionDelegate> *_Nullable)iqaCreateTipView:(BOOL)isPortratOrientation;

@end

@protocol AAIIQATakePhotoTipViewDataSource <NSObject>

@required

- (UIView *_Nullable)iqaCreateTakePhotoTipView:(BOOL)isPortratOrientation;

@end

NS_ASSUME_NONNULL_END
